package com.walker.tcp.netty;

import com.walker.infrastructure.ServerId;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import io.netty.channel.socket.nio.NioSocketChannel;

/**
 * 生成长连接通道ID。自定义该对象。
 * @author 时克英
 * @date 2023-09-29
 */
@Deprecated
public class GenIdClientSocketChannel extends NioSocketChannel {

    public GenIdClientSocketChannel(){}

    public GenIdClientSocketChannel(Channel parent, java.nio.channels.SocketChannel socket) {
        super(parent, socket);
//        this.config = new NioSocketChannelConfig(this, socket.socket());
    }

    @Override
    protected ChannelId newId() {
        ChannelId channelId = new ChannelId() {
            @Override
            public String asShortText() {
                return new StringBuilder(ServerId.getId())
                        .append(StringUtils.STRING_UNDERLINE).append(NumberGenerator.getSequenceNumber())
                        .append(StringUtils.STRING_UNDERLINE).append(StringUtils.generateRandomNumber(8)).toString();
//                return UUID.randomUUID().toString();
            }

            @Override
            public String asLongText() {
//                return UUID.randomUUID().toString();
                return new StringBuilder(ServerId.getId())
                        .append(StringUtils.STRING_UNDERLINE).append(NumberGenerator.getLongSequenceNumber())
                        .append(StringUtils.STRING_UNDERLINE).append(StringUtils.generateRandomNumber(8)).toString();
            }

            @Override
            public int compareTo(ChannelId o) {
                return 0;
            }
        };
        return channelId;
    }
}
