package com.walker.tcp.netty;

import com.walker.infrastructure.ServerId;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import io.netty.channel.ChannelId;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.internal.SocketUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.channels.SocketChannel;
import java.util.List;

/**
 * 生成长连接通道ID。自定义该对象。
 * @author 时克英
 * @date 2023-09-29
 */
@Deprecated
public class GenIdNioSocketChannel extends NioServerSocketChannel {

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    protected int doReadMessages(List<Object> buf) throws Exception {
        SocketChannel ch = SocketUtils.accept(this.javaChannel());

        try {
            if (ch != null) {
//                buf.add(new NioSocketChannel(this, ch));
                buf.add(new GenIdClientSocketChannel(this, ch));
                return 1;
            }
        } catch (Throwable var6) {
            logger.warn("Failed to create a new channel from an accepted socket.", var6);

            try {
                ch.close();
            } catch (Throwable var5) {
                logger.warn("Failed to close a socket.", var5);
            }
        }

        return 0;
    }

    @Override
    protected ChannelId newId() {
        ChannelId channelId = new ChannelId() {
            @Override
            public String asShortText() {
                return new StringBuilder(ServerId.getId())
                        .append(StringUtils.STRING_UNDERLINE).append(NumberGenerator.getSequenceNumber())
                        .append(StringUtils.STRING_UNDERLINE).append(StringUtils.generateRandomNumber(8)).toString();
//                return UUID.randomUUID().toString();
            }

            @Override
            public String asLongText() {
//                return UUID.randomUUID().toString();
                return new StringBuilder(ServerId.getId())
                        .append(StringUtils.STRING_UNDERLINE).append(NumberGenerator.getLongSequenceNumber())
                        .append(StringUtils.STRING_UNDERLINE).append(StringUtils.generateRandomNumber(8)).toString();
            }

            @Override
            public int compareTo(ChannelId o) {
                return 0;
            }
        };
        return channelId;
    }

//    /**
//     * 返回集群中主机服务ID编号，在集群中唯一。
//     * @return
//     */
//    public String getServerId() {
//        return serverId;
//    }
//
//    public void setServerId(String serverId) {
//        this.serverId = serverId;
//    }
//
//    private String serverId = "0";
}
