package com.walker.tcp.netty;

import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.stream.ChunkedWriteHandler;

public class WebSocketServerInitializer extends DefaultServerInitializer {

//	public void setPackageSeparator(String packageSeparator) {
//		throw new UnsupportedOperationException("websocket类型不支持该操作");
//	}

	@Override
	protected void initChannel(SocketChannel ch) throws Exception {
//	protected void initChannel(GenIdClientSocketChannel ch) throws Exception {
		logger.debug("SocketChannel = {}", ch.getClass().getName());
		ChannelPipeline pipeline = ch.pipeline();

		pipeline.addLast("logging",new LoggingHandler(LogLevel.INFO));

		// 设置30秒没有读到数据，则触发一个READER_IDLE事件。
		// pipeline.addLast(new IdleStateHandler(30, 0, 0));

		// HttpServerCodec：将请求和应答消息解码为HTTP消息
		pipeline.addLast("http-codec",new HttpServerCodec());

		// HttpObjectAggregator：将HTTP消息的多个部分合成一条完整的HTTP消息
		pipeline.addLast("aggregator",new HttpObjectAggregator(65536));

		// ChunkedWriteHandler：向客户端发送HTML5文件
		pipeline.addLast("http-chunked",new ChunkedWriteHandler());

		// 在管道中添加我们自己的接收数据实现方法
		pipeline.addLast("handler", this.getHandler());
	}

}
