package com.walker.tcp.support;

import com.walker.tcp.Connection;

/**
 * 简单的单引擎连接管理器实现。
 * @author 时克英
 * @date 2018-08-16
 *
 */
public class SimpleEngineConnectionManager extends AbstractConnectionManager {

	public SimpleEngineConnectionManager(){
		// 默认提供一个内存连接缓存实现。2023-09-19
		this.setConnectionCache(new MemoryConnectionCache());
	}

	@Override
	protected void onSaveConnection(Connection connection) throws Exception {
		logger.debug("保存了一个连接：" + connection.getName());
	}

	@Override
	protected void onDeleteConnection(int engineId, String name) throws Exception {
		logger.debug("删除了一个连接：" + name);
	}

	@Override
	protected void onUpdateLastTime(int engineId, String name, long lastTime) throws Exception {
		logger.debug("更新了一个连接：" + name);
	}

	@Override
	protected void onUpdateConnection(Connection connection) throws Exception {
		// 单机模式中，未使用该方法。
	}

}
