package com.walker.tcp.websocket;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.tcp.TcpRequest;
import com.walker.tcp.data.AbstractStringRequest;
import com.walker.tcp.util.WebSocketUtils;

@TcpRequest("hello")
public class HelloRequest extends AbstractStringRequest {

	/**
	 *
	 */
	private static final long serialVersionUID = 5322523893566046088L;

	private String summary;

	public String getSummary() {
		return summary;
	}

	@Override
	protected void translateData(String source) {
		try {
			ObjectNode objectNode = JsonUtils.jsonStringToObjectNode(source);
			this.setName(objectNode.get(WebSocketUtils.WEB_SOCKET_KEY_UID).asText());
			this.summary = objectNode.get("summary").textValue();
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
//		JSONObject json = JSONObject.parseObject(source);
//		this.setName(json.getString(WebSocketUtils.WEB_SOCKET_KEY_UID));
//		this.summary = json.getString("summary");
	}

	@Override
	public String getProtocolNum() {
		return "hello";
	}

}
