/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp;

import com.walker.tcp.ServerHandler;
import com.walker.tcp.handler.AbstractStringHandler;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class RequestPostProcessor
implements BeanPostProcessor {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Map<String, String> reference = new TreeMap<String, String>();

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (ServerHandler.class.isAssignableFrom(bean.getClass())) {
            AbstractStringHandler pr = (AbstractStringHandler)bean;
            reference.putAll(pr.getMapper());
            this.logger.info("\u627e\u5230\u4e86\u4e00\u4e2aServerHandler\uff1a" + pr.getClass().getName());
        }
        return bean;
    }

    public static final String getAction(String protocolNum) {
        if (reference.size() == 0) {
            throw new IllegalArgumentException("\u672a\u914d\u7f6e\u4efb\u4f55request\u5bf9\u8c61");
        }
        String action = reference.get(protocolNum);
        if (action == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5b9a\u4e49\u7684request\u5b9e\u73b0\u7c7b\uff0cprotocolNum = " + protocolNum);
        }
        return action;
    }

    public static final Map<String, String> getActionList() {
        return reference;
    }
}

