/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.netty;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.tcp.Response;
import com.walker.tcp.connect.LongConnection;
import com.walker.tcp.netty.DefaultServerInitializer;
import com.walker.tcp.support.AbstractTcpLongEngine;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class DefaultLongEngine
extends AbstractTcpLongEngine {
    private ListeningClientThread serverStartThread = null;
    private EventLoopGroup bossGroup = null;
    private EventLoopGroup workerGroup = null;
    private int bossThreadNum = 2;
    private int workerThreadNum = 4;
    private DefaultServerInitializer serverInitializer;
    private static final String ERROR_NO_NAME = "\u7f3a\u5c11\u901a\u9053\u6216\u8bbe\u5907\u552f\u4e00id\uff0c\u65e0\u6cd5\u63a8\u9001\u6d88\u606f";
    private static final String ERROR_NO_CONNECTION = "\u672a\u627e\u5230\u8fde\u63a5\uff0c\u65e0\u6cd5\u63a8\u9001tcp\u6570\u636e";

    public void setBossThreadNum(int bossThreadNum) {
        this.bossThreadNum = bossThreadNum;
    }

    public void setWorkerGroup(EventLoopGroup workerGroup) {
        this.workerGroup = workerGroup;
    }

    public void setWorkerThreadNum(int workerThreadNum) {
        this.workerThreadNum = workerThreadNum;
    }

    public void setServerInitializer(DefaultServerInitializer serverInitializer) {
        this.serverInitializer = serverInitializer;
    }

    @Override
    protected void onStart() throws Exception {
        if (this.serverInitializer == null) {
            throw new IllegalArgumentException("\u7f3a\u5c11\uff1aDefaultServerInitializer\u53c2\u6570");
        }
        this.serverStartThread = new ListeningClientThread();
        this.serverStartThread.start();
    }

    @Override
    protected void onShutdown() throws Exception {
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        if (this.serverStartThread != null) {
            this.serverStartThread.interrupt();
        }
        this.logger.info("***************************************");
        this.logger.info("\u957f\u8fde\u63a5\u5f15\u64ce\u88ab\u5173\u95ed\uff1a" + this.getName() + ", port = " + this.getPort());
        this.logger.info("***************************************");
    }

    @Override
    protected String onSendResponse(Response<?> response) {
        String name = response.getName();
        if (StringUtils.isEmpty((String)name)) {
            return ERROR_NO_NAME;
        }
        LongConnection conn = (LongConnection)this.getConnectionManager().getConnectionByName(name);
        if (conn == null) {
            this.logger.warn("\u672a\u627e\u5230\u8fde\u63a5\uff0c\u65e0\u6cd5\u63a8\u9001tcp\u6570\u636e, name=" + name + ", content=");
            return ERROR_NO_CONNECTION;
        }
        conn.write(response);
        this.logger.debug(conn.getName() + ", " + conn.getConnectionHost() + ", " + conn.getClass().getName());
        if (!response.getProtocolNum().equals("heartbeat")) {
            conn.setLastTime(System.currentTimeMillis());
        }
        if (response.getProtocolNum().equals("login") && this.connectionCallback != null) {
            this.connectionCallback.onAfterLogin(conn);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u53d1\u9001\u4e00\u6761\u6d88\u606f\u5230\u5ba2\u6237\u7aef\uff1a" + response);
        }
        return null;
    }

    private class ListeningClientThread
    extends Thread {
        public ListeningClientThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            if (DefaultLongEngine.this.getEngineStartDelaySeconds() > 0L) {
                try {
                    DefaultLongEngine.this.logger.info("ListeningClientThread \u5ef6\u65f6\u542f\u52a8\uff08\u79d2\uff09={}", (Object)DefaultLongEngine.this.getEngineStartDelaySeconds());
                    TimeUnit.SECONDS.sleep(DefaultLongEngine.this.getEngineStartDelaySeconds());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("\u76d1\u542ctcp\u5ba2\u6237\u7aef\u7ebf\u7a0b\u5ef6\u65f6\u542f\u52a8\uff0c\u88ab\u4e2d\u65ad:" + e.getMessage(), e);
                }
            }
            DefaultLongEngine.this.bossGroup = new NioEventLoopGroup(DefaultLongEngine.this.bossThreadNum, (ThreadFactory)new DefaultThreadFactory("bossServer", true));
            DefaultLongEngine.this.workerGroup = new NioEventLoopGroup(DefaultLongEngine.this.workerThreadNum, (ThreadFactory)new DefaultThreadFactory("workerGroup", true));
            ServerBootstrap b = new ServerBootstrap();
            b.group(DefaultLongEngine.this.bossGroup, DefaultLongEngine.this.workerGroup);
            b.channel(NioServerSocketChannel.class);
            b.childHandler((ChannelHandler)DefaultLongEngine.this.serverInitializer);
            DefaultLongEngine.this.logger.info("***************************************");
            DefaultLongEngine.this.logger.info("\u957f\u8fde\u63a5\u5f15\u64ce\u542f\u52a8\uff0c\u7aef\u53e3\uff1a" + DefaultLongEngine.this.getPort());
            DefaultLongEngine.this.logger.info("\u540d\u79f0\uff1a" + DefaultLongEngine.this.getName());
            DefaultLongEngine.this.logger.info("***************************************");
            try {
                ChannelFuture f = b.bind(DefaultLongEngine.this.getPort()).sync();
                f.channel().closeFuture().sync();
            }
            catch (Exception ex) {
                DefaultLongEngine.this.logger.error(null, (Throwable)ex);
                DefaultLongEngine.this.bossGroup.shutdownGracefully();
                DefaultLongEngine.this.workerGroup.shutdownGracefully();
                throw new RuntimeException("\u542f\u52a8\u957f\u8fde\u63a5\u5f15\u64ce\u5931\u8d25\uff0c\u6b63\u5728\u5173\u95ed\uff1a" + this.getName());
            }
        }
    }
}

