/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.netty;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.tcp.connect.LongConnection;
import com.walker.tcp.netty.DefaultLongHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;

public class WebSocketNettyHandler
extends DefaultLongHandler {
    private WebSocketServerHandshaker handshaker;
    private String uri;

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        String textMessage = null;
        if (msg instanceof FullHttpRequest) {
            this.handleHttpRequest(ctx, (FullHttpRequest)msg);
            textMessage = "websocket";
            this.msgThreadLocal.set(textMessage);
        } else if (msg instanceof WebSocketFrame) {
            textMessage = this.handlerWebSocketFrame(ctx, (WebSocketFrame)msg);
            String id = ctx.channel().id().asLongText();
            LongConnection conn = (LongConnection)this.connectionManager.getConnection(id);
            this.msgThreadLocal.set(textMessage);
            this.tcpServerHandler.onRead(conn, textMessage);
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u8be5\u6d88\u606f\u7c7b\u578b\uff1a" + msg.getClass().getName());
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        String id = ctx.channel().id().asLongText();
        Object msg = this.msgThreadLocal.get();
        if (msg != null && msg.toString().equals("websocket")) {
            return;
        }
        this.tcpServerHandler.onReadComplete(msg, id, ctx);
        this.msgThreadLocal.set(null);
        super.channelReadComplete(ctx);
    }

    private String handlerWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            System.out.println(1);
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
            return null;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.channel().write((Object)new PongWebSocketFrame(frame.content().retain()));
            return null;
        }
        if (frame instanceof PongWebSocketFrame) {
            return null;
        }
        if (!(frame instanceof TextWebSocketFrame)) {
            throw new UnsupportedOperationException(String.format("%s frame types not supported", frame.getClass().getName()));
        }
        return ((TextWebSocketFrame)frame).text();
    }

    public void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) {
        if (StringUtils.isEmpty((String)this.uri)) {
            throw new IllegalArgumentException("WebSocketHandler: websocket uri \u672a\u8bbe\u7f6e");
        }
        if (!req.decoderResult().isSuccess()) {
            WebSocketNettyHandler.sendHttpResponse(ctx, req, new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
            return;
        }
        this.logger.debug("================ ws://" + ctx.channel() + "/websocket");
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.uri, null, false);
        this.handshaker = wsFactory.newHandshaker((HttpRequest)req);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            this.handshaker.handshake(ctx.channel(), req);
        }
    }

    private static void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, DefaultFullHttpResponse res) {
        if (res.status().code() != 200) {
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)res.status().toString(), (Charset)CharsetUtil.UTF_8);
            res.content().writeBytes(buf);
            buf.release();
        }
        ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
        if (!HttpUtil.isKeepAlive((HttpMessage)req) || res.status().code() != 200) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

