/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.support;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.security.SystemLogMan;
import com.walker.tcp.Connection;
import com.walker.tcp.ConnectionCallback;
import com.walker.tcp.ConnectionManager;
import com.walker.tcp.ProtocolResolver;
import com.walker.tcp.Response;
import com.walker.tcp.TcpEngine;
import com.walker.tcp.lb.LongConnectionMeta;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTcpLongEngine
implements TcpEngine {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private int port = 5800;
    private String name;
    private ConnectionManager connectionManager;
    private boolean openHeartBeat = true;
    private int id = 0;
    private List<ProtocolResolver<?>> protocolResolverList;
    protected ConnectionCallback connectionCallback;
    long startTime = 0L;
    boolean started = false;
    private int currentFailedTime = 0;
    private long heartBeatTimeInterval = 300000L;
    private Thread kernelThread = null;
    private ExecutorService executorService = Executors.newFixedThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            AbstractTcpLongEngine.this.kernelThread = new Thread(r);
            AbstractTcpLongEngine.this.kernelThread.setDaemon(true);
            return AbstractTcpLongEngine.this.kernelThread;
        }
    });
    private InteralTimerRunner timerRunner = new InteralTimerRunner();
    private long engineStartDelaySeconds = 120L;

    public void setConnectionCallback(ConnectionCallback connectionCallback) {
        this.connectionCallback = connectionCallback;
    }

    public List<ProtocolResolver<?>> getProtocolResolverList() {
        return this.protocolResolverList;
    }

    public void setProtocolResolverList(List<ProtocolResolver<?>> protocolResolverList) {
        this.protocolResolverList = protocolResolverList;
    }

    public boolean isOpenHeartBeat() {
        return this.openHeartBeat;
    }

    public void setOpenHeartBeat(boolean openHeartBeat) {
        this.openHeartBeat = openHeartBeat;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean supportLongConnection() {
        return true;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public void start() throws Exception {
        try {
            SystemLogMan.getInstance().checkMan();
            this.onStart();
            this.startTime = System.currentTimeMillis();
            if (this.openHeartBeat) {
                this.startHeartBeatThread();
            }
        }
        catch (Exception ex) {
            this.logger.error("\u542f\u52a8\u957f\u8fde\u63a5\u5931\u8d25\uff1a" + this.getName(), (Throwable)ex);
            throw new Exception(ex);
        }
    }

    private void startHeartBeatThread() {
        if (this.started) {
            throw new IllegalStateException("\u957f\u8fde\u63a5\u5df2\u542f\u52a8\uff0c\u8c03\u7528\u72b6\u6001\u9519\u8bef\u3002name = " + this.name);
        }
        this.executorService.execute(this.timerRunner);
        this.logger.info("\u957f\u8fde\u63a5'" + this.name + "'\u542f\u52a8......");
        this.started = true;
    }

    @Override
    public void shutdown() throws Exception {
        this.onShutdown();
    }

    @Override
    public String sendResponse(Response<?> response) {
        if (!this.supportLongConnection()) {
            throw new IllegalStateException("\u6539\u5f15\u64ce\u4e0d\u652f\u6301\u957f\u8fde\u63a5\uff0c\u4e0d\u80fd\u5411\u5ba2\u6237\u7aef\u63a8\u9001\u6d88\u606f");
        }
        return this.onSendResponse(response);
    }

    public void sendBroadcast(Response<?> response) {
        List<Connection> clientList = this.connectionManager.queryAllConnectionListBy(this.getId());
        this.logger.debug("------> \u51c6\u5907\u53d1\u9001\u5e7f\u64ad\uff0cengineId = {}, \u5ba2\u6237\u7aef\u6570\u91cf\uff1a{}", (Object)this.getId(), (Object)(clientList == null ? 0 : clientList.size()));
        if (!StringUtils.isEmptyList(clientList)) {
            for (Connection conn : clientList) {
                conn.write(response);
            }
        }
    }

    protected abstract void onStart() throws Exception;

    protected abstract void onShutdown() throws Exception;

    protected abstract String onSendResponse(Response<?> var1);

    public long getHeartBeatTimeInterval() {
        return this.heartBeatTimeInterval;
    }

    public void setHeartBeatTimeInterval(long timeInterval) {
        this.heartBeatTimeInterval = timeInterval;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        if (id <= 0 || id >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("engine id must 0~65536");
        }
        if (this.id > 0) {
            throw new IllegalArgumentException("engine id already exist, id = " + this.id);
        }
        this.id = id;
    }

    public long getEngineStartDelaySeconds() {
        return this.engineStartDelaySeconds;
    }

    public void setEngineStartDelaySeconds(long engineStartDelaySeconds) {
        this.engineStartDelaySeconds = engineStartDelaySeconds;
    }

    private class InteralTimerRunner
    implements Runnable {
        private boolean stop = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                try {
                    List<Connection> list = AbstractTcpLongEngine.this.connectionManager.queryAllConnectionListBy(AbstractTcpLongEngine.this.getId());
                    if (StringUtils.isEmptyList(list)) continue;
                    long currentTime = System.currentTimeMillis();
                    for (Connection conn : list) {
                        if (AbstractTcpLongEngine.this.logger.isDebugEnabled()) {
                            AbstractTcpLongEngine.this.logger.debug(AbstractTcpLongEngine.this.getId() + " \u53d1\u9001\u5fc3\u8df3\u6570\u636e\uff0cname\uff1a" + conn.getName());
                        }
                        if (!(conn instanceof LongConnectionMeta)) {
                            conn.write(conn.getProtocolResolver().getHeartBeatResponse());
                        }
                        if (AbstractTcpLongEngine.this.connectionCallback == null || (currentTime - conn.getLastTime()) / 1000L < 600L) continue;
                        AbstractTcpLongEngine.this.connectionCallback.onIdle(conn);
                    }
                }
                catch (Exception ex) {
                    if (AbstractTcpLongEngine.this.currentFailedTime >= Integer.MAX_VALUE) {
                        AbstractTcpLongEngine.this.currentFailedTime = 0;
                    }
                    ++AbstractTcpLongEngine.this.currentFailedTime;
                    AbstractTcpLongEngine.this.logger.error("\u8fde\u63a5\u68c0\u6d4b\u7ebf\u7a0b\u8c03\u7528\u5931\u8d25\u4e00\u6b21 ", (Throwable)ex);
                }
                finally {
                    try {
                        if (AbstractTcpLongEngine.this.heartBeatTimeInterval <= 0L) continue;
                        AbstractTcpLongEngine.this.logger.debug("*************** sleep: " + AbstractTcpLongEngine.this.heartBeatTimeInterval);
                        TimeUnit.MILLISECONDS.sleep(AbstractTcpLongEngine.this.heartBeatTimeInterval);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

