/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.support;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.tcp.Connection;
import com.walker.tcp.ConnectionCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MemoryConnectionCache
implements ConnectionCache {
    private final Map<String, Connection> cached = new ConcurrentHashMap<String, Connection>(128);
    private Map<String, String> idNameCached = new ConcurrentHashMap<String, String>(128);

    @Override
    public void putConnection(Connection connection) {
        String id = connection.getId();
        if (StringUtils.isEmpty((String)id)) {
            throw new IllegalArgumentException("connection id \u5fc5\u987b\u5b58\u5728");
        }
        this.cached.put(id, connection);
        this.idNameCached.put(connection.getName(), id);
    }

    @Override
    public void removeConnection(String id) {
        Connection connection = this.cached.get(id);
        if (connection != null) {
            this.idNameCached.remove(connection.getName());
        }
        this.cached.remove(id);
    }

    @Override
    public void removeConnection(String id, Connection connection) {
        if (connection == null) {
            connection = this.cached.get(id);
        }
        if (connection != null) {
            this.idNameCached.remove(connection.getName());
        }
        this.cached.remove(id);
    }

    @Override
    public void updateConnection(Connection connection) {
        this.cached.put(connection.getId(), connection);
    }

    @Override
    public Connection getConnection(String id) {
        return this.cached.get(id);
    }

    @Override
    public Connection getConnectionByName(String name) {
        String id = this.idNameCached.get(name);
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        return this.cached.get(id);
    }

    @Override
    public String getIdByName(String name) {
        return this.idNameCached.get(name);
    }

    @Override
    public List<Connection> getAllConnectionList() {
        ArrayList<Connection> result = new ArrayList<Connection>();
        for (Connection conn : this.cached.values()) {
            result.add(conn);
        }
        return result;
    }

    @Override
    public List<Connection> getAllConnectionListBy(int engineId) {
        ArrayList<Connection> result = new ArrayList<Connection>();
        for (Connection conn : this.cached.values()) {
            if (conn.getEngineId() != engineId) continue;
            result.add(conn);
        }
        return result;
    }
}

