/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.support;

import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.core.ApplicationBeanInitialized;
import com.walker.queue.AbstractQueueManager;
import com.walker.queue.QueueException;
import com.walker.tcp.ActionCallException;
import com.walker.tcp.ActionCallable;
import com.walker.tcp.ActionCallablePostProcessor;
import com.walker.tcp.Connection;
import com.walker.tcp.ConnectionManager;
import com.walker.tcp.Context;
import com.walker.tcp.Filter;
import com.walker.tcp.Request;
import com.walker.tcp.Response;
import com.walker.tcp.support.SimpleContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MemoryQueueManager
extends AbstractQueueManager
implements ApplicationBeanInitialized {
    private final BlockingQueue<Request<?>> dataQueue = new ArrayBlockingQueue(2048);
    private final List<Filter> filterList = new ArrayList<Filter>();
    private int filterCount = 0;
    private ExecutorService service = Executors.newFixedThreadPool(this.maxWorkerThread);
    private Runnable consumer = new DefaultConsumer();
    private ConnectionManager connectionManager;

    public void addFilter(Filter filter) {
        for (Filter f : this.filterList) {
            if (!filter.getName().equalsIgnoreCase(f.getName())) continue;
            throw new IllegalArgumentException("\u5df2\u7ecf\u5b58\u5728\u8be5\u8fc7\u6ee4\u5668\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
        this.filterList.add(filter);
        ++this.filterCount;
    }

    public void push(String key, Object data, Object option) throws QueueException {
        if (data == null) {
            throw new QueueException("request is required!");
        }
        if (!Request.class.isAssignableFrom(data.getClass())) {
            throw new QueueException("\u8bf7\u6c42\u5bf9\u8c61\u5fc5\u987b\u662f: " + Request.class.getName());
        }
        try {
            this.dataQueue.put((Request)data);
            this.logger.debug("\u52a0\u5165\u4e00\u4e2a\u6570\u636e\u5230\u961f\u5217\uff1a" + data);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void processFailed(Request<?> request) {
        this.logger.error("tcp\u6d88\u606f\u5904\u7406\u5931\u8d25\uff0c\u53ef\u80fd\u8fde\u63a5\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u5173\u95ed\uff0c\u8bb0\u5f55\u65e5\u5fd7\uff1a" + request.toString());
    }

    protected void processSuccess(Request<?> request) {
        this.logger.debug("tcp\u6d88\u606f\u5904\u7406\u6210\u529f\uff1a" + request.getProtocolNum());
    }

    public void startup() {
        if (this.connectionManager == null) {
            throw new IllegalArgumentException("connectionManager\u672a\u914d\u7f6e");
        }
        this.logger.info("\u521d\u59cb\u5316TcpAction\u6d88\u8d39\u8005\u4efb\u52a1\uff1a" + this.consumer.getClass().getName());
        this.service.execute(this.consumer);
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    private class DefaultConsumer
    implements Runnable {
        private DefaultConsumer() {
        }

        @Override
        public void run() {
            MemoryQueueManager.this.logger.info("\u5904\u7406websocket\u7ebf\u7a0b\u542f\u52a8\uff1a" + this.getClass().getName());
            while (true) {
                try {
                    while (true) {
                        Request<?> request = MemoryQueueManager.this.dataQueue.take();
                        SimpleContext context = new SimpleContext(request, (Request)MemoryQueueManager.this.dataQueue.peek());
                        MemoryQueueManager.this.logger.debug("\u6d88\u8d39\u8005\u62ff\u5230\u4e00\u4e2a\u6570\u636e\uff1a" + request);
                        if (MemoryQueueManager.this.filterCount > 0) {
                            boolean filterResult = true;
                            for (Filter f : MemoryQueueManager.this.filterList) {
                                filterResult = f.doFilter(context);
                                if (filterResult) continue;
                                MemoryQueueManager.this.logger.debug("\u8fc7\u6ee4\u5668\u7ec8\u6b62\u64cd\u4f5c\uff1a" + f.getName());
                                break;
                            }
                            if (!filterResult) {
                                return;
                            }
                        }
                        MemoryQueueManager.this.service.execute(new ActionInvokeTask(context));
                    }
                }
                catch (InterruptedException e) {
                    MemoryQueueManager.this.logger.error(DefaultConsumer.class.getName() + "\u6d88\u8d39\u8005\u4efb\u52a1\u4e2d\u65ad", (Throwable)e);
                    continue;
                }
                catch (Exception e) {
                    MemoryQueueManager.this.logger.error("\u6267\u884c\u4efb\u52a1\u51fa\u73b0\u9519\u8bef", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    private class ActionInvokeTask
    implements Runnable {
        private Context context;

        public ActionInvokeTask(Context context) {
            this.context = context;
        }

        @Override
        public void run() {
            Request<?> request = this.context.getCurrentData();
            ActionCallable action = ActionCallablePostProcessor.getAction(request.getProtocolNum());
            if (action == null) {
                throw new ApplicationRuntimeException("action\u672a\u5b9a\u4e49\uff0cprotocol = " + request.getProtocolNum());
            }
            try {
                if (request.isRequireResponse()) {
                    Response<?> response = action.action(request);
                    response.setName(request.getName());
                    Connection conn = MemoryQueueManager.this.connectionManager.getConnectionByName(request.getName());
                    if (conn == null || !conn.isConnected()) {
                        MemoryQueueManager.this.processFailed(request);
                        return;
                    }
                    conn.write(response);
                    MemoryQueueManager.this.processSuccess(request);
                } else {
                    action.action(request);
                    MemoryQueueManager.this.logger.debug("\u8be5\u8bf7\u6c42\u4e0d\u9700\u8981\u54cd\u5e94\uff1a" + request);
                }
            }
            catch (ActionCallException ex) {
                MemoryQueueManager.this.processFailed(request);
                MemoryQueueManager.this.logger.error("\u6267\u884caction\u9519\u8bef\uff1a" + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

