/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.util;

import java.math.BigInteger;
import java.text.DecimalFormat;

public class ByteUtils {
    public static String toBinary(byte b) {
        StringBuilder stringBuilder = new StringBuilder();
        String val = ByteUtils.byteToHexString(b);
        BigInteger integer = new BigInteger(val, 16);
        stringBuilder.append(integer.toString(2));
        while (stringBuilder.length() < 8) {
            stringBuilder.insert(0, "0");
        }
        return stringBuilder.toString();
    }

    public static int getHeight4(byte data) {
        int height = (data & 0xF0) >> 4;
        return height;
    }

    public static int getLow4(byte data) {
        int low = data & 0xF;
        return low;
    }

    public static int delH(int val) {
        val = (val << 1 & 0xFF) >>> 1;
        return val;
    }

    public static String byteToHexString(byte src) {
        StringBuilder stringBuilder = new StringBuilder("");
        int v = src & 0xFF;
        String hv = Integer.toHexString(v);
        if (hv.length() < 2) {
            stringBuilder.append(0);
        }
        stringBuilder.append(hv);
        return stringBuilder.toString();
    }

    public static String bytesToHexString(byte[] src, int begin, int len) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        int end = begin + len;
        for (int i = begin; i < end; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String bytesToHexString2(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv).append(" ");
        }
        return stringBuilder.toString();
    }

    public static String toHexString(byte[] byteArray) {
        if (byteArray == null || byteArray.length < 1) {
            throw new IllegalArgumentException("this byteArray must not be null or empty");
        }
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < byteArray.length; ++i) {
            if ((byteArray[i] & 0xFF) < 16) {
                hexString.append("0");
            }
            hexString.append(Integer.toHexString(0xFF & byteArray[i]));
        }
        return hexString.toString().toLowerCase();
    }

    public static String[] bytesToHexStrings(byte[] src) {
        String s = ByteUtils.bytesToHexString(src);
        String[] ss = new String[src.length];
        for (int j = 0; j < ss.length; ++j) {
            ss[j] = s.substring(2 * j, 2 * (j + 1));
        }
        return ss;
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.replaceAll(" ", "");
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(ByteUtils.charToByte(hexChars[pos]) << 4 | ByteUtils.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static String int2HexString(int src) {
        StringBuilder stringBuilder = new StringBuilder();
        String hv = Integer.toHexString(src);
        if (hv.length() < 2) {
            stringBuilder.append(0);
        }
        stringBuilder.append(hv);
        return stringBuilder.toString();
    }

    public static String intToHexString(int src) {
        byte[] b = ByteUtils.toBytes(src);
        return ByteUtils.bytesToHexString(b);
    }

    public static String intToHexStringH(int src) {
        byte[] b = ByteUtils.toBytesH(src);
        return ByteUtils.bytesToHexString(b);
    }

    public static String toHexString(String src) {
        return ByteUtils.intToHexString(Integer.valueOf(src));
    }

    public static String intTo4HexString(int src) {
        return ByteUtils.bytesToHexString(ByteUtils.intToBytes(src));
    }

    public static byte[] toByteArray(int iSource, int iArrayLen) {
        byte[] bLocalArr = new byte[iArrayLen];
        for (int i = 0; i < iArrayLen; ++i) {
            bLocalArr[i] = (byte)(iSource >> 8 * i);
        }
        return bLocalArr;
    }

    public static byte[] toBytes(int v) {
        byte[] targets = new byte[]{(byte)(0xFF & v), (byte)(0xFF & v >> 8)};
        return targets;
    }

    public static byte[] toBytesH(int v) {
        byte[] targets = new byte[2];
        targets[1] = (byte)(0xFF & v);
        targets[0] = (byte)(0xFF & v >> 8);
        return targets;
    }

    public static byte[] intToBytes(int num) {
        byte[] targets = new byte[]{(byte)(num & 0xFF), (byte)(num >> 8 & 0xFF), (byte)(num >> 16 & 0xFF), (byte)(num >>> 24)};
        return targets;
    }

    public static int toInt3(byte[] bs, int begain) {
        int accum = 0;
        accum = bs[begain + 0] & 0xFF;
        accum |= (bs[begain + 1] & 0xFF) << 8;
        return accum |= (bs[begain + 2] & 0xFF) << 16;
    }

    public static int toInt4(byte[] bs) {
        int accum = 0;
        accum = bs[0] & 0xFF;
        accum |= (bs[1] & 0xFF) << 8;
        accum |= (bs[2] & 0xFF) << 16;
        return accum |= (bs[3] & 0xFF) << 24;
    }

    public static int toIntByH(byte[] bs, int start) {
        int accum = 0;
        accum = bs[start + 3] & 0xFF;
        accum |= (bs[start + 2] & 0xFF) << 8;
        accum |= (bs[start + 1] & 0xFF) << 16;
        return accum |= (bs[start + 0] & 0xFF) << 24;
    }

    public static int toInt4(byte[] bs, int pos) {
        int accum = 0;
        accum = bs[pos + 0] & 0xFF;
        accum |= (bs[pos + 1] & 0xFF) << 8;
        accum |= (bs[pos + 2] & 0xFF) << 16;
        return accum |= (bs[pos + 3] & 0xFF) << 24;
    }

    public static double toDouble(byte[] res, int begainIdx) {
        Double data = (double)ByteUtils.toInt2(res, begainIdx) * 0.01;
        DecimalFormat bd = new DecimalFormat("#.00");
        data = Double.valueOf(bd.format(data));
        return data;
    }

    public static int toInt2(byte[] res, int begainIdx) {
        int targets = res[begainIdx] & 0xFF | res[begainIdx + 1] << 8 & 0xFF00;
        return targets;
    }

    public static int toInt2(byte[] res) {
        int targets = res[0] & 0xFF | res[1] << 8 & 0xFF00;
        return targets;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String getMsgCmd(byte[] msg) {
        byte[] cmd = new byte[]{msg[6], msg[7]};
        return ByteUtils.bytesToHexString(cmd);
    }

    public static String getCommand(byte[] cmdArea) {
        return ByteUtils.bytesToHexString(cmdArea);
    }

    public static String itoj(String str, int i, int j) {
        String[] strs = str.split("\\s+");
        Object result = "";
        for (String string : strs) {
            String hex = Integer.toString(Integer.parseInt(string, i), j);
            result = (String)result + hex;
        }
        return result;
    }

    public static void main(String[] args) {
        byte[] b = new byte[]{-86, -11};
        int i = ByteUtils.toInt2(b);
        System.out.println("byte[] value = " + i);
    }
}

