package com.walker.tcp;

import com.walker.db.page.GenericPager;

import java.util.List;
import java.util.Map;

public interface ConnectionManager {

	GenericPager<Connection> queryPageConnectionList(int pageIndex, int pageSize);

	List<Connection> queryAllConnectionList();

	Connection getConnection(int engineId, String id);

	void updateLastTime(int engineId, String id);

	void removeConnection(int engineId, String id);

	void updateConnection(int engineId, String id, Connection connection);

	void putConnection(int engineId, Connection connection);

	Connection getConnection(String id);

	void updateLastTime(String id);

	void removeConnection(String id);

	void updateConnection(String id, Connection connection);

	void putConnection(Connection connection);

	boolean isSupportMultipleEngine();

	/**
	 * 业务系统根据提供的绑定名称，查找连接对象。如：设备ID
	 * @param name
	 * @return
	 */
	Connection getConnectionByName(String name);

	/**
	 * 根据终端设备名称，删除连接对象
	 * @param name
	 */
	void removeConnectionByName(String name);

	List<Connection> queryAllConnectionListBy(int engineId);

	String getConnectionTypeName(int engineId);

	Map<Integer, String> getConnectionTypeMap();

//	/**
//	 * 是否支持未注册设备连接服务，如果允许（true）那么系统中未定义的设备也可以连接平台并提交数据。
//	 * @return
//	 */
//	boolean isPermitNotRegisterConnect();

}
