package com.walker.tcp;

/**
 * 描述：报文消息格式定义
 * @author 时克英
 * @date 2020年8月18日 下午4:08:53
 */

public interface Message {

	/**
	 * 获得报文特征，如：
	 * <pre>
	 * 1. IW开头的消息
	 * 2. 0xAA0xF5开头的消息（十进制：170 245）
	 * </pre>
	 * @return
	 */
	byte[] getFeature();
	
	/**
	 * 返回报文总长度（包括：标识、负载所有内容）
	 * @return
	 */
	int getTotalSize();
	
	/**
	 * 消息是否加密
	 * @return
	 */
	boolean isEncrypt();
	
	/**
	 * 获取加解密方式
	 * @return
	 */
	Object getEncryptType();
	
	/**
	 * 获取报文协议类型，如：AP00等
	 * @return
	 */
	Object getProtocol();
	
	/**
	 * 得到负载数据（业务报文）
	 * @return
	 */
	Object getPayload();
}
