package com.walker.tcp;

import java.io.Serializable;

/**
 * 定义TCP通信中请求规范
 * @author Administrator
 * @author 时克英
 * @date 2017-09-20
 */
public interface Request<T> extends Serializable {

	/**
	 * 把原始通信输入转换成请求对象可以用的数据。</p>
	 * 该方法通常由子类来实现解析，这属于业务协议规则。我们会设置一个抽象类做流程控制，最终业务子类实现业务内容解析。
	 * @param source
	 */
	void fromSource(T source);

	/**
	 * 返回业务对应的请求终端ID，如：设备唯一ID等
	 * @return
	 */
	String getName();

	/**
	 * 返回系统接收到该消息的时间戳
	 * @return
	 */
	long getTimeStamp();

	/**
	 * 返回业务协议中，约定的协议名称，即：接口名称，如：001代表登录请求，002代表登录响应
	 * @return
	 */
	String getProtocolNum();

	/**
	 * 返回商业数据，这些通常只包括业务部分内容
	 * @return
	 */
	String getBusinessContent();

	/**
	 * 返回请求与响应约定的消息ID，通常该值由业务事先约定好，在双向通信中，都可以使用。
	 * @return
	 */
	String getMessageId();

	/**
	 * 是否该请求需要响应？</p>
	 * 对于象：指令下达这样的场景中，下达后客户端也是会回应（请求）确认收到，此时这种请求是不需要服务端响应的。</p>
	 * 服务端可以通过该确认，更新系统状态。
	 * @return
	 */
	boolean isRequireResponse();

	void setProtocolResolverId(int protocolResolverId);

	int getProtocolResolverId();

//	ProtocolResolver getProtocolResolver();
//
//	/**
//	 * 设置报文解析器对象，connection对象要使用
//	 * @param resolver
//	 */
//	void setProtocolResolver(ProtocolResolver resolver);

	/**
	 * 返回本次连接通道的id值
	 * @return
	 */
	String getSessionId();
}
