package com.walker.tcp;

public interface TcpEngine {

	int getPort();

	/**
	 * 返回通信引擎名字，由业务设置
	 * @return
	 */
	String getName();

	/**
	 * 是否支持长连接，默认支持
	 * @return
	 */
	boolean supportLongConnection();

	/**
	 * 返回连接管理器，注意：该方法只有长连接时才存在
	 * @return
	 */
	ConnectionManager getConnectionManager();

	void start() throws Exception;

	void shutdown() throws Exception;

	/**
	 * 通过长连接，向客户端发送异步消息
	 * @param response
	 * @return 返回（失败）信息，返回null表示通道发送成功。
	 */
	String sendResponse(Response<?> response);

	long getStartTime();

	/**
	 * 引擎ID
	 * @return
	 */
	int getId();
}
