package com.walker.tcp;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * TCP通信连接中，请求对象注解。系统通过该注解就可以自动获得其关联的数据协议。
 * @author 时克英
 * @date 2018-11-23
 *
 */
@Target(ElementType.TYPE)// 注解会在class字节码文件中存在，在运行时可以通过反射获取到
@Retention(RetentionPolicy.RUNTIME)//定义注解的作用目标
public @interface TcpRequest {

	String value() default "";

}
