package com.walker.tcp.connect;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.tcp.Connection;
import com.walker.tcp.ProtocolResolver;
import com.walker.tcp.Request;
import com.walker.tcp.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public  class AbstractConnection implements Connection {

	protected final transient Logger logger = LoggerFactory.getLogger(getClass());

	private String id;
	private String name;
	private long createTimeMills = 0;
	private boolean longConnection = true;
	private boolean idle = false;

	private boolean authenticated = false;
	private int engineId = 0;
	private long lastTime = 0;

	private String connectionHost;

	public AbstractConnection(String id){
		this.id = id;
//		this.name = name;
		if(this.supportLongConnection()){
			this.createTimeMills = NumberGenerator.getSequenceNumber();
		}
	}

	public AbstractConnection(){}

	@Override
	public String getId() {
		return id;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public long getCreateTimeMills() {
		return createTimeMills;
	}

	@Override
	public boolean supportLongConnection() {
		return longConnection;
	}

	@Override
	public boolean isIdle() {
		return idle;
	}

	@JsonIgnore
	@Override
	public Request<?> read() {
		return null;
	}

	@JsonIgnore
	@Override
	public void write(Response<?> response) {
		if(response == null){
			logger.warn("响应对象为null，不能发送出去");
		}
	}

	@JsonIgnore
	@Override
	public void disconnect() {

	}

	@Override
	public String toString(){
		return new StringBuilder().append("[ id=").append(id)
				.append(", name=").append(name)
				.append(", createTIme=").append(createTimeMills)
				.append(", authenticated=").append(this.authenticated)
				.append(", alreadyLogin=").append(this.alreadyLogin)
				.append(", connectionHost=").append(this.connectionHost)
				.append(", longConnection=").append(this.longConnection)
				.append("]").toString();
	}

	@Override
	public boolean equals(Object obj){
		if(obj == null){
			return false;
		}
		if(obj instanceof AbstractConnection){
			AbstractConnection c = (AbstractConnection)obj;
			if(c.getName() != null && c.getName().equals(this.name)){
				return true;
			}
			if(c.getId().equals(this.id)){
				return true;
			}
		}
		return false;
	}

	@Override
	public int hashCode(){
		if(StringUtils.isNotEmpty(this.name)){
			return 31 + this.name.hashCode() * 13;
		}
		return 31 + this.id.hashCode() * 13;
	}

	@Override
	public void setName(String name) {
		this.name = name;
	}

	@Override
	public boolean isAuthenticated() {
		return authenticated;
	}

	protected void setAuthenticated(boolean result){
		this.authenticated = result;
	}

	public boolean getAuthenticated(){
		return this.authenticated;
	}

	@Override
	public int getEngineId() {
		return engineId;
	}

	public void setEngineId(int id){
		this.engineId = id;
	}

	@Override
	public long getLastTime() {
		return lastTime;
	}

	public void setLastTime(long mills){
		this.lastTime = mills;
	}

	@JsonIgnore
	@Override
	public void bindName(String name) {
		if(StringUtils.isNotEmpty(this.name)){
			throw new IllegalStateException("连接已经绑定了名称，不能重复绑定");
		}
		this.name = name;
		this.setAuthenticated(true);
		// 是否已登录，json转换添加新字段，authenticated一直不生效。2023-09-27
		this.setAlreadyLogin(1);
	}

	@Override
	public boolean isConnected() {
		return false;
	}

	@JsonIgnore
	private ProtocolResolver protocolResolver;

	@Override
	public ProtocolResolver getProtocolResolver() {
		return protocolResolver;
	}

	@Override
	public void setProtocolResolver(ProtocolResolver protocolResolver) {
		this.protocolResolver = protocolResolver;
	}

	@Override
	public String getConnectionHost() {
		return this.connectionHost;
	}
	@Override
	public void setConnectionHost(String connectionHost) {
		this.connectionHost = connectionHost;
	}

	// 为序列化生成的方法。
	// 2023-09-27
	public void setId(String id) {
		this.id = id;
	}

	public void setCreateTimeMills(long createTimeMills) {
		this.createTimeMills = createTimeMills;
	}

	public boolean getLongConnection() {
		return longConnection;
	}

	public void setLongConnection(boolean longConnection) {
		this.longConnection = longConnection;
	}

	public void setIdle(boolean idle) {
		this.idle = idle;
	}

	@Override
	public int getAlreadyLogin() {
		return alreadyLogin;
	}

	public void setAlreadyLogin(int alreadyLogin) {
		this.alreadyLogin = alreadyLogin;
	}

	private int alreadyLogin = 0;
}
