package com.walker.tcp.data;

/**
 * 以普通文本请求的具体实现
 * @author 时克英
 * 创建日期：2018-08-20</p>
 * 修改日期：2018-09-20
 *
 */
public  abstract class AbstractStringRequest extends BaseRequest<String> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 5871183343102621901L;


	@Override
	public void fromSource(String source) {
		if(timeStamp == 0){
			timeStamp = System.currentTimeMillis();
		}
		this.translateData(source);
	}

	/**
	 * 业务来做具体数据转换，把字符串里面的内容解析成对象属性，这些业务属性由子类按照需要定义。
	 * @param source
	 */
	protected abstract void translateData(String source);

}
