package com.walker.tcp.lb;

import com.walker.support.redis.cache.RedisCacheProvider;
import com.walker.tcp.Constants;

/**
 * 长连接，名称与ID缓存。
 * <p>key = name, value = id </p>
 * @author 时克英
 * @date 2023-09-25
 */
public class RedisConnectionNameCache extends RedisCacheProvider<String> {

    public RedisConnectionNameCache(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    public void removeConnectionName(String name){
        this.removeCacheData(name);
    }

    /**
     * 根据连接名称获取对应ID
     * @param name
     * @return
     */
    public String getConnectionId(String name){
        return this.getCacheData(name);
    }

    public void putConnectionName(String name, String id){
        this.putCacheData(name, id);
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_CONNECTION_NAME;
    }

    @Override
    public Class<?> getProviderType() {
        return String.class;
    }
}
