package com.walker.tcp.lb;

import com.walker.tcp.Response;

/**
 * 发送响应消息的写入对象。
 * <pre>
 *     1) 由于<code>LongConnectionMeta</code>对象序列化存储到Redis后，反序列化是不知道具体子类的，
 *     因此只能通过该对象实现具体发送过程。
 * </pre>
 * @author 时克英
 * @date 2023-09-28
 */
public interface ResponseWriter {

    public static final String TYPE_MQ = "mq";

    /**
     * 写入数据到具体通道中
     * @param type 类型，见常量：{@linkplain ResponseWriter#TYPE_MQ}
     * @param response 响应数据
     * @param connectionHost 当前连接元数据对应的主机信息
     * @param channelId 通道ID
     * @return
     * @date 2023-09-28
     */
    Object write(String type, Response<?> response, String connectionHost, String channelId);
}
