package com.walker.tcp.littleD;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.tcp.data.AbstractStringRequest;

/**
 * 使用中科信通，小D产品终端，抽取的请求数据对象。</p>
 * 其他请求对象都必须继承该对象，完成具体商业数据的解析。
 * @author 时克英
 * @date 2018-08-17
 *
 */
public abstract class AbstractRequest extends AbstractStringRequest {

	/**
	 *
	 */
	private static final long serialVersionUID = -4235184960828684415L;

	private String protocolNum;
	private String content;

	@Override
	protected void translateData(String source) {
		if(StringUtils.isEmpty(source)){
			throw new IllegalArgumentException("请求原始数据不存在，无法解析");
		}

		int size = source.length();
		if(size < 6){
			throw new IllegalArgumentException("非法报文长度");
		}

		if(!source.startsWith(Constants.BODY_ID)){
			throw new IllegalArgumentException("非法报文头");
		}

		protocolNum = source.substring(2, 6);
		if(size > 6){
			content = source.substring(6);
			this.translateBusiness(content);
		}
	}

	@Override
	public String getProtocolNum() {
		return protocolNum;
	}

	@Override
	public String getBusinessContent() {
		return content;
	}

	/**
	 * 纯商务数据解析，已经去掉了协议号等公共内容
	 * @param business
	 */
	protected abstract void translateBusiness(String business);
}
