package com.walker.tcp.msg;

import com.walker.tcp.Message;

/**
 * 描述：
 * @author 时克英
 * @date 2020年8月19日 下午11:06:43
 */

public abstract class MyAbstractMessage implements Message {

	private byte[] feature;
	private int totalSize = 0;
	private boolean encrypt = false;
	private Object encryptType = null;
	private Object protocol = null;
	private Object payload = null;
	
	public void setFeature(byte[] feature) {
		this.feature = feature;
	}

	public void setTotalSize(int totalSize) {
		this.totalSize = totalSize;
	}

	public void setEncrypt(boolean encrypt) {
		this.encrypt = encrypt;
	}

	public void setEncryptType(Object encryptType) {
		this.encryptType = encryptType;
	}

	public void setProtocol(Object protocol) {
		this.protocol = protocol;
	}

	public void setPayload(Object payload) {
		this.payload = payload;
	}

	@Override
	public byte[] getFeature() {
		return this.feature;
	}

	@Override
	public int getTotalSize() {
		return this.totalSize;
	}

	@Override
	public boolean isEncrypt() {
		return this.encrypt;
	}

	@Override
	public Object getEncryptType() {
		return this.encryptType;
	}

	@Override
	public Object getProtocol() {
		return this.protocol;
	}

	@Override
	public Object getPayload() {
		return this.payload;
	}
	
	/**
	 * 解析具体消息内容，由子类实现。
	 * @param msg
	 */
	protected abstract void parseMessage(byte[] msg);
}
