package com.walker.tcp.netty;

import com.walker.tcp.Response;
import com.walker.tcp.connect.LongConnection;
import io.netty.channel.ChannelHandlerContext;

/**
 * 由netty底层实现的长连接对象，该连接被抽象为一个长的TCP连接句柄。
 * @author 时克英
 *
 */
public class DefaultLongConnection extends LongConnection {

	public ChannelHandlerContext ctx;

	public DefaultLongConnection(String id){
		super(id);
	}

	public DefaultLongConnection(String id, ChannelHandlerContext ctx){
		super(id);
		if(ctx == null){
			throw new IllegalArgumentException("构造'DefaultLongConnection'失败，缺少构造参数：ChannelHandlerContext");
		}
		this.ctx = ctx;
	}

	@Override
	public void write(Response<?> response) {
		super.write(response);
		this.ctx.writeAndFlush(response.toData());
	}

	@Override
	public void disconnect() {
//		ChannelFuture result = this.ctx.close();
		 this.ctx.close();
	}

	@Override
	public boolean isConnected() {
		return ctx.channel().isOpen();
	}

	public void setChannelHandlerContext(ChannelHandlerContext ctx){
		this.ctx = ctx;
	}
}
