package com.walker.tcp.netty;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.tcp.ProtocolResolver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.concurrent.TimeUnit;

public class DefaultServerInitializer extends ChannelInitializer<SocketChannel> {
//public class DefaultServerInitializer extends ChannelInitializer<GenIdClientSocketChannel> {

	protected final transient Logger logger = LoggerFactory.getLogger(getClass());

//	private LongHandler businessHandler;
	private DefaultLongHandler handler;

	private boolean showLog = false;

//	public void setBusinessHandler(LongHandler businessHandler) {
//		this.businessHandler = businessHandler;
//	}

    // 消息分隔符
//    private String packageSeparator = "#";
//	private String[] separators = null;

	public void setShowLog(boolean showLog) {
		this.showLog = showLog;
	}

	private List<ProtocolResolver<?>> protocolResolverList;

	private int timeOutRead = 0;
	private int timeOutWrite = 0;
	private int timeOutAll = 0;

	public void setTimeOutRead(int timeOutRead) {
		this.timeOutRead = timeOutRead;
	}

	public void setTimeOutWrite(int timeOutWrite) {
		this.timeOutWrite = timeOutWrite;
	}

	public void setTimeOutAll(int timeOutAll) {
		this.timeOutAll = timeOutAll;
	}

	/**
	 * 设置协议解析器集合
	 * @param protocolResolverList
	 */
	public void setProtocolResolverList(List<ProtocolResolver<?>> protocolResolverList) {
		this.protocolResolverList = protocolResolverList;
	}

//	public void setPackageSeparator(String packageSeparators) {
//		if(StringUtils.isNotEmpty(packageSeparators)){
//			separators = packageSeparators.split(StringUtils.DEFAULT_SPLIT_SEPARATOR);
//		}
//	}

	/**
	 * 设置系统handler
	 * @param handler
	 */
	public void setHandler(DefaultLongHandler handler) {
		this.handler = handler;
	}

	@Override
	protected void initChannel(SocketChannel ch) throws Exception {
//	protected void initChannel(GenIdClientSocketChannel ch) throws Exception {
		logger.debug("SocketChannel = {}", ch.getClass().getName());
		ChannelPipeline pipeline = ch.pipeline();

		if(this.showLog){
			pipeline.addLast("logging",new LoggingHandler(LogLevel.INFO));
		}

		// 以("\n")为结尾分割的 解码器
//		pipeline.addLast("framer", new DelimiterBasedFrameDecoder(8192, Delimiters.lineDelimiter()));

		// 以#结尾
//		pipeline.addLast("framer", new DelimiterBasedFrameDecoder(8192, Unpooled.wrappedBuffer(new byte[] { '#' })));
		/**
		if(separators == null){
			throw new IllegalStateException("未定义tcp分隔符，无法启动netty服务");
		}

		ByteBuf[] decoderFrames = new ByteBuf[separators.length+1];
		for(int i=0; i<separators.length; i++){
			logger.info("服务端设置了分隔符：" + separators[i]);
			decoderFrames[i] = Unpooled.wrappedBuffer(separators[i].getBytes());
		}

		// 把回车换行作为最后默认的分隔符
		logger.info("服务端设置默认分隔符：回车换行");
		decoderFrames[separators.length] = Unpooled.wrappedBuffer("\r\n".getBytes());
		*/
//		pipeline.addLast("framer", new PlatformBaseFrameDecoder(8192, decoderFrames));
		this.initProtocolResolvers(pipeline);

		// 字符串解码 和 编码
		pipeline.addLast("decoder", new StringDecoder());
		pipeline.addLast("encoder", new StringEncoder());

		// 自己的逻辑Handler
//		LongHandler businessHandler = new LongHandler();
//		businessHandler.setConnectionManager(connectionManager);
//		businessHandler.setConvertor(convertor);
//		businessHandler.setAuthenticate(authenticate);
//
//		DefaultLongHandler handler  = new DefaultLongHandler();
//		handler.setConnectionManager(connectionManager);
//		handler.setTcpServerHandler(businessHandler);

		// 添加超时设置，2019-10-12
		pipeline.addLast(new IdleStateHandler(this.timeOutRead, this.timeOutWrite, this.timeOutAll, TimeUnit.SECONDS));

		pipeline.addLast("handler", handler);
//		pipeline.addLast("ping", new IdleStateHandler(30, 300, 60));
	}

	protected void initProtocolResolvers(ChannelPipeline pipeline){
		if(StringUtils.isEmptyList(protocolResolverList)){
			throw new IllegalStateException(ProtocolResolver.ERR_NOFOUND);
		}

		ByteBuf[] decoderFrames = new ByteBuf[protocolResolverList.size()];
		for(int i=0; i<protocolResolverList.size(); i++){
			logger.info("服务端设置了分隔符：" + protocolResolverList.get(i).getDelimiter());
			decoderFrames[i] = Unpooled.wrappedBuffer(protocolResolverList.get(i).getDelimiter().getBytes());
		}

//		pipeline.addLast("framer", new DelimiterBasedFrameDecoder(8192, Unpooled.wrappedBuffer(packageSeparator.getBytes()), Unpooled.wrappedBuffer("\r\n".getBytes())));
		pipeline.addLast("framer", new DelimiterBasedFrameDecoder(8192, false, decoderFrames));
	}

	public DefaultLongHandler getHandler() {
		return handler;
	}
}
