package com.walker.tcp.protocol;

import com.walker.tcp.ProtocolException;
import com.walker.tcp.ProtocolResolver;
import com.walker.tcp.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProtocolResolver<T> implements ProtocolResolver<T> {

	protected final transient Logger logger = LoggerFactory.getLogger(getClass());

	private String name;

//	private String feature;
	private Object feature;

	private String delimiter;

	private int order = 0;

	public int getOrder() {
		return order;
	}

	public void setOrder(int order) {
		this.order = order;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setProtocolFeature(Object feature) {
		this.feature = feature;
	}

	public void setDelimiter(String delimiter) {
		this.delimiter = delimiter;
	}

	@Override
	public String getName() {
		return this.name;
	}

	@Override
	public String getProtocolNum(T data, int size) throws ProtocolException {
		return this.onResolve(data, size);
	}

	@Override
//	public String getProtocolFeature() {
	public Object getProtocolFeature() {
		return this.feature;
	}

	@Override
	public String getDelimiter() {
		return this.delimiter;
	}

	/**
	 * 解析具体数据协议编号
	 * @param data
	 * @return
	 * @throws ProtocolException
	 */
//	protected abstract String onResolve(String data, int size) throws ProtocolException;
	protected abstract String onResolve(T data, int size) throws ProtocolException;

	@Override
	public boolean isRequireFeatureResolve(){
		return false;
	}

	/**
	 * 该方法为了在界面上让freemarker展示使用
	 * @return
	 */
	public boolean getRequireFeatureResolve(){
		return isRequireFeatureResolve();
	}

	private Response<?> heartBeatResponse = null;

	public Response<?> getHeartBeatResponse(){
		if(heartBeatResponse == null){
			heartBeatResponse = this.doCreateOneResponse();
		}
		return heartBeatResponse;
	}

	/**
	 * 产生一个心跳响应对象
	 * @return
	 */
	protected abstract Response<?> doCreateOneResponse();

	private boolean permitNotRegisterConnect = false;

	public void setPermitNotRegisterConnect(boolean permitNotRegisterConnect) {
		this.permitNotRegisterConnect = permitNotRegisterConnect;
	}

	/**
	 * 判断是否允许未注册设备连接平台，如果设置为false，那么该方法将配合：isRegistered()来限制未注册设备访问。</p>
	 * 子类需要重新覆盖isReistered()方法。
	 */
	public boolean isPermitNotRegisterConnect(){
		return permitNotRegisterConnect;
	}

	/**
	 * 该方法返回是否终端设备已经再平台注册，如果不允许“未注册设备连接”的话，需要重写该方法，确认设备列表中是否注册有该设备
	 * @param clientId
	 * @return
	 * @author 时克英
	 * @date 2018-12-03
	 */
	protected boolean isRegistered(String clientId){
		return true;
	}

	@Override
	public boolean isOnlyMatchFeature(){
		return false;
	}
}
