package com.walker.tcp.protocol;

import com.walker.tcp.AuthenticateException;
import com.walker.tcp.ProtocolException;
import com.walker.tcp.Request;
import com.walker.tcp.Response;

public class LineProtocolResolver extends StringProtocolResolver {

	public LineProtocolResolver(){
		this.setDelimiter("\r\n");
		this.setName("默认报文解析器");
		this.setOrder(99);
		this.setProtocolFeature(null);
	}
	
	@Override
	protected String onResolve(String data, int size) throws ProtocolException {
		throw new ProtocolException("该解析器是系统默认解析器，出现这个错误说明业务没有配置自己的解析器类型");
	}

	@Override
	protected Response<?> doCreateOneResponse() {
		throw new UnsupportedOperationException();
	}

	@Override
	public String getAuthenticateInfo(Request<?> request) throws AuthenticateException {
		return null;
	}

}
