package com.walker.tcp.util;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.tcp.Message;
import com.walker.tcp.ProtocolResolver;
import com.walker.tcp.TcpRequest;
import com.walker.tcp.protocol.MessageProtocolResolver;
import org.reflections.Reflections;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConvertorUtils {

	/**
	 * 返回制定包下面的所有<code>TcpRequest</code>注解类集合
	 * @param packageName
	 * @return
	 */
	public static Map<String, String> scanTcpRequestAnnotation(String packageName){
		Reflections reflections = new Reflections(packageName);
		Set<Class<?>> classesList = reflections.getTypesAnnotatedWith(TcpRequest.class);

		if(classesList != null){
			Map<String, String> map = new HashMap<>();
			TcpRequest annotation = null;
			for(Class<?> c : classesList){
				annotation = c.getAnnotation(TcpRequest.class);
				if(annotation == null){
					continue;
				}
				if(StringUtils.isEmpty(annotation.value())){
					throw new IllegalArgumentException("TcpRequest注解没有设置value，必须配置。class = " + c.getName());
				}
				map.put(annotation.value(), c.getName());
			}
			return map;
		}
		return null;
	}

//	/**
//	 * 根据报文内容，找到使用的协议解析器。</p>
//	 * 目前系统根据后缀来查找
//	 * @param message
//	 * @return
//	 */
//	@Deprecated
////	public static final ProtocolResolver<?> getProtocolResolver(String message, List<ProtocolResolver<?>> resolverList){
//	public static final ProtocolResolver<?> getProtocolResolver(String message, List<ProtocolResolver<?>> resolverList){
////		if(cacheList == null){
////			throw new IllegalArgumentException(ProtocolResolver.ERR_NOFOUND);
////		}
////		for(ProtocolResolver<?> pr : resolverList){
//		for(ProtocolResolver<?> pr : resolverList){
//			if(pr instanceof MessageProtocolResolver){
//				continue;
//			}
//			if(message.endsWith(pr.getDelimiter())){
//				if(pr.isRequireFeatureResolve()){
//					if(pr.getProtocolFeature() == null){
//						throw new IllegalArgumentException(ProtocolResolver.ERR_NO_FEATURE + pr.getName());
//					}
//					if(message.startsWith(pr.getProtocolFeature().toString())){
//						return pr;
//					} else {
//						continue;
//					}
//				} else {
//					return pr;
//				}
//			}
//		}
//		return null;
//	}

	public static final ProtocolResolver<?> getProtocolResolver(Object msg, List<ProtocolResolver<?>> resolverList){
		if(msg == null){
			throw new IllegalArgumentException("msg(Object) is required!");
		}

		Object feature = null;
		String msgStr = null;

		for(ProtocolResolver<?> pr : resolverList){
			if(msg instanceof Message){
				// 如果不行可以用这个判断类型
//				Message.class.isAssignableFrom(msg.getClass())
				Message message = (Message)msg;
				if(pr.isOnlyMatchFeature()){
					if(pr instanceof MessageProtocolResolver){
						feature = pr.getProtocolFeature();
						if(feature != null){
							if(Arrays.equals(message.getFeature(), (byte[])feature)){
								return pr;
							}
						}
						continue;

					} else {
						// 如果是其他 MessageProtocolResolver 自定义实现，再扩展
						throw new UnsupportedOperationException("需要扩展报文解析类型：" + message.toString());
					}
				} else {
					// 可能需要报文分隔符来进一步确定类型，可能是长报文类型，暂未实现
					throw new UnsupportedOperationException("未实现的报文解析类型：" + message.toString());
				}
			} else {
				// 这里其他情况目前只有字符串类型
				if(pr instanceof MessageProtocolResolver){
					continue;
				}

				msgStr = msg.toString();
				if(msgStr.endsWith(pr.getDelimiter())){
					if(pr.isRequireFeatureResolve()){
						if(pr.getProtocolFeature() == null){
							throw new IllegalArgumentException(ProtocolResolver.ERR_NO_FEATURE + pr.getName());
						}
						if(msgStr.startsWith(pr.getProtocolFeature().toString())){
							return pr;
						} else {
							continue;
						}
					} else {
						return pr;
					}
				}
			}
//			if(message.endsWith(pr.getDelimiter())){
//				if(pr.isRequireFeatureResolve()){
//					if(pr.getProtocolFeature() == null){
//						throw new IllegalArgumentException(ProtocolResolver.ERR_NO_FEATURE + pr.getName());
//					}
//					if(message.startsWith(pr.getProtocolFeature())){
//						return pr;
//					} else {
//						continue;
//					}
//				} else {
//					return pr;
//				}
//			}
		}
		return null;
	}

	public static void main(String[] args){
		Map<String, String> map = scanTcpRequestAnnotation("com.walker.tcp");
		if(map == null){
			return;
		}
		for(Map.Entry<String, String> entry : map.entrySet()){
			System.out.println(entry.getKey() + ", " + entry.getValue());
		}
	}
}
