package com.walker.tcp.websocket;

import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.tcp.data.BaseResponse;
import com.walker.tcp.util.WebSocketUtils;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;

import java.util.HashMap;
import java.util.Map;

public abstract class JsonResponse extends BaseResponse<Object> {

	/**
	 *
	 */
	private static final long serialVersionUID = -7971496621709107413L;

	private Map<String, Object> result = new HashMap<>(4);

	public JsonResponse(){
		this.setDelimiter(StringUtils.EMPTY_STRING);
	}

	@Override
	public TextWebSocketFrame toData() {
		result.put(WebSocketUtils.WEB_SOCKET_KEY_PROTOCOL, this.getProtocolNum());
		result.put(WebSocketUtils.WEB_SOCKET_KEY_UID, this.getName());
		this.translateProperties(result);
//		return new TextWebSocketFrame(result.toJSONString());
		try {
			return new TextWebSocketFrame(JsonUtils.objectToJsonString(result));
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * 由子类实现，把业务属性转换到系统生成的Json对象中。如：</p>
	 * <pre>
	 * result.put("name", this.name);
	 * result.put("money", this.money);
	 * </pre>
	 *
	 * @param result
	 */
	protected abstract void translateProperties(Map<String, Object> result);

//	@Override
//	public String getDelimiter() {
//		return StringUtils.EMPTY_STRING;
//	}
}
