/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.tcp.ActionCallable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ActionCallablePostProcessor
implements BeanPostProcessor {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Map<String, ActionCallable> reference = new ConcurrentHashMap<String, ActionCallable>();

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (ActionCallable.class.isAssignableFrom(bean.getClass())) {
            ActionCallable pr = (ActionCallable)bean;
            if (StringUtils.isEmpty((String)pr.getRequestProtocol())) {
                this.logger.error(pr.getSummary() + "," + pr.getClassName() + ", " + pr.getClass().getName());
                throw new IllegalArgumentException("ActionCallable\u672a\u5b9e\u73b0getRequestProtocol()\u65b9\u6cd5!");
            }
            reference.put(pr.getRequestProtocol(), pr);
            this.logger.info("\u627e\u5230\u4e86\u4e00\u4e2aActionCallable\uff1a" + pr.getClass().getName());
        }
        return bean;
    }

    public static final ActionCallable getAction(String protocolNum) {
        if (reference.size() == 0) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u4efb\u4f55\u914d\u7f6e\u7684ActionCallable\u5b9e\u4f8b\uff0ctcp\u4e1a\u52a1\u65e0\u6cd5\u7ee7\u7eed\u5904\u7406!");
        }
        ActionCallable action = reference.get(protocolNum);
        if (action == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5b9a\u4e49\u7684ActionCallable\uff0cprotocolNum = " + protocolNum);
        }
        return action;
    }

    public static final List<ActionCallable> getActionList() {
        ArrayList<ActionCallable> result = new ArrayList<ActionCallable>();
        for (ActionCallable action : reference.values()) {
            result.add(action);
        }
        return result;
    }

    public static final void setTestActions(Map<String, ActionCallable> map) {
        if (reference.size() > 0) {
            System.out.println("++++++++++ " + reference);
            throw new IllegalStateException("reference\u5df2\u7ecf\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u80fd\u8986\u76d6\u3002\u8be5\u65b9\u6cd5\u53ea\u80fd\u5728\u6d4b\u8bd5\u65f6\u4f7f\u7528!");
        }
        reference = map;
    }
}

