/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp;

import com.walker.tcp.ProtocolResolver;
import com.walker.tcp.protocol.StringProtocolResolver;
import com.walker.tcp.util.ConvertorUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ProtocolResolverPostProcessor
implements BeanPostProcessor {
    private final transient Log logger = LogFactory.getLog(this.getClass());
    private static final Map<Integer, ProtocolResolver<?>> reference = new HashMap();
    private static List<ProtocolResolver<?>> cacheList = null;
    private final InnerComparator comparator = new InnerComparator();

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (ProtocolResolver.class.isAssignableFrom(bean.getClass())) {
            ProtocolResolver pr = (ProtocolResolver)bean;
            if (cacheList == null) {
                cacheList = new ArrayList(4);
            }
            if (this.isDuplicateOrder(pr.getOrder())) {
                throw new IllegalArgumentException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u5e8f\u53f7\u7684ProtocolResolver\u5bf9\u8c61\uff0corder = " + pr.getOrder());
            }
            cacheList.add(pr);
            reference.put(pr.getOrder(), pr);
            this.logger.info((Object)("\u627e\u5230\u4e86\u4e00\u4e2aProtocolResolver\uff1a" + pr.getName()));
            Collections.sort(cacheList, this.comparator);
        }
        return bean;
    }

    private boolean isDuplicateOrder(int order) {
        for (ProtocolResolver<?> pr : cacheList) {
            if (order < 0 || order != pr.getOrder()) continue;
            return true;
        }
        return false;
    }

    public static final ProtocolResolver<?> getProtocolResolver(int order) {
        ProtocolResolver<?> pr = reference.get(order);
        if (pr == null) {
            throw new IllegalArgumentException("\u7cfb\u7edf\u672a\u914d\u7f6e\u4efb\u4f55ProtocolResolver\u5bf9\u8c61\uff0c\u65e0\u6cd5\u89e3\u6790\u62a5\u6587");
        }
        return pr;
    }

    public static final StringProtocolResolver getProtocolResolver(String message) {
        if (cacheList == null) {
            throw new IllegalArgumentException("\u7cfb\u7edf\u672a\u914d\u7f6e\u4efb\u4f55ProtocolResolver\u5bf9\u8c61\uff0c\u65e0\u6cd5\u89e3\u6790\u62a5\u6587");
        }
        return (StringProtocolResolver)ConvertorUtils.getProtocolResolver(message, cacheList);
    }

    public static List<ProtocolResolver<?>> getProtocolResolverList() {
        return cacheList;
    }

    public static void testAddResolver(ProtocolResolver<?> pr) {
        if (cacheList == null) {
            cacheList = new ArrayList(4);
        }
        cacheList.add(pr);
        reference.put(pr.getOrder(), pr);
        Collections.sort(cacheList, new InnerComparator());
    }

    private static class InnerComparator
    implements Comparator<ProtocolResolver<?>> {
        private InnerComparator() {
        }

        @Override
        public int compare(ProtocolResolver<?> o1, ProtocolResolver<?> o2) {
            return o1.getOrder() - o2.getOrder();
        }
    }
}

