/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.coder;

import com.walker.tcp.msg.MyOEMMessage;
import com.walker.tcp.util.ByteUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageDecoder
extends MessageToMessageDecoder<ByteBuf> {
    protected final transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final byte[] feature = new byte[]{-86, -11};
    private final int sizeWithoutData = 9;

    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        byte[] msgFeature = new byte[2];
        msg.readBytes(msgFeature);
        if (msgFeature[0] != this.feature[0] || msgFeature[1] != this.feature[1]) {
            this.logger.warn((Object)("\u672a\u8bc6\u522b\u7684\u8bbe\u5907\u8bf7\u6c42\u7279\u5f81:" + Arrays.toString(msgFeature)));
            out.add(null);
            return;
        }
        msg.readBytes(msgFeature);
        int contentSize = ByteUtils.toInt2(msgFeature);
        if (contentSize != msg.capacity()) {
            this.logger.error((Object)("\u8bf7\u6c42\u8bbe\u5907\u6570\u636e\u957f\u5ea6\u9519\u8bef\uff0c\u6570\u636e\u63d0\u4f9b\u957f\u5ea6:" + contentSize + "\uff0c\u5b9e\u9645\u957f\u5ea6:" + msg.capacity()));
            out.add(null);
            return;
        }
        MyOEMMessage message = new MyOEMMessage();
        message.setTotalSize(contentSize);
        byte info = msg.readByte();
        byte serialNum = msg.readByte();
        msg.readBytes(msgFeature);
        message.setProtocol(ByteUtils.getCommand(msgFeature));
        byte[] data = new byte[contentSize - 9];
        msg.readBytes(data);
        message.setPayload(data);
        out.add(message);
    }
}

