/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.connect;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.tcp.Connection;
import com.walker.tcp.ProtocolResolver;
import com.walker.tcp.Request;
import com.walker.tcp.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractConnection
implements Connection {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String id;
    private String name;
    private long createTimeMills = 0L;
    private boolean longConnection = true;
    private boolean idle = false;
    private boolean authenticated = false;
    private int engineId = 0;
    private long lastTime = 0L;
    private String connectionHost;
    @JsonIgnore
    private ProtocolResolver protocolResolver;
    private int alreadyLogin = 0;

    public AbstractConnection(String id) {
        this.id = id;
        if (this.supportLongConnection()) {
            this.createTimeMills = NumberGenerator.getSequenceNumber();
        }
    }

    public AbstractConnection() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getCreateTimeMills() {
        return this.createTimeMills;
    }

    @Override
    public boolean supportLongConnection() {
        return this.longConnection;
    }

    @Override
    public boolean isIdle() {
        return this.idle;
    }

    @Override
    @JsonIgnore
    public Request<?> read() {
        return null;
    }

    @Override
    @JsonIgnore
    public void write(Response<?> response) {
        if (response == null) {
            this.logger.warn("\u54cd\u5e94\u5bf9\u8c61\u4e3anull\uff0c\u4e0d\u80fd\u53d1\u9001\u51fa\u53bb");
        }
    }

    @Override
    @JsonIgnore
    public void disconnect() {
    }

    public String toString() {
        return "[ id=" + this.id + ", name=" + this.name + ", createTIme=" + this.createTimeMills + ", authenticated=" + this.authenticated + ", alreadyLogin=" + this.alreadyLogin + ", connectionHost=" + this.connectionHost + ", longConnection=" + this.longConnection + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof AbstractConnection) {
            AbstractConnection c = (AbstractConnection)obj;
            if (c.getName() != null && c.getName().equals(this.name)) {
                return true;
            }
            if (c.getId().equals(this.id)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (StringUtils.isNotEmpty((String)this.name)) {
            return 31 + this.name.hashCode() * 13;
        }
        return 31 + this.id.hashCode() * 13;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    protected void setAuthenticated(boolean result) {
        this.authenticated = result;
    }

    public boolean getAuthenticated() {
        return this.authenticated;
    }

    @Override
    public int getEngineId() {
        return this.engineId;
    }

    public void setEngineId(int id) {
        this.engineId = id;
    }

    @Override
    public long getLastTime() {
        return this.lastTime;
    }

    public void setLastTime(long mills) {
        this.lastTime = mills;
    }

    @Override
    @JsonIgnore
    public void bindName(String name) {
        if (StringUtils.isNotEmpty((String)this.name)) {
            throw new IllegalStateException("\u8fde\u63a5\u5df2\u7ecf\u7ed1\u5b9a\u4e86\u540d\u79f0\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a");
        }
        this.name = name;
        this.setAuthenticated(true);
        this.setAlreadyLogin(1);
    }

    @Override
    public boolean isConnected() {
        return false;
    }

    @Override
    public ProtocolResolver getProtocolResolver() {
        return this.protocolResolver;
    }

    @Override
    public void setProtocolResolver(ProtocolResolver protocolResolver) {
        this.protocolResolver = protocolResolver;
    }

    @Override
    public String getConnectionHost() {
        return this.connectionHost;
    }

    @Override
    public void setConnectionHost(String connectionHost) {
        this.connectionHost = connectionHost;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCreateTimeMills(long createTimeMills) {
        this.createTimeMills = createTimeMills;
    }

    public boolean getLongConnection() {
        return this.longConnection;
    }

    public void setLongConnection(boolean longConnection) {
        this.longConnection = longConnection;
    }

    public void setIdle(boolean idle) {
        this.idle = idle;
    }

    @Override
    public int getAlreadyLogin() {
        return this.alreadyLogin;
    }

    public void setAlreadyLogin(int alreadyLogin) {
        this.alreadyLogin = alreadyLogin;
    }
}

