/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.handler;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.queue.QueueManager;
import com.walker.tcp.AuthenticateException;
import com.walker.tcp.Connection;
import com.walker.tcp.ConnectionManager;
import com.walker.tcp.ProtocolResolver;
import com.walker.tcp.ProtocolResolverPostProcessor;
import com.walker.tcp.Request;
import com.walker.tcp.ServerHandler;
import com.walker.tcp.connect.LongConnection;
import com.walker.tcp.data.AbstractStringRequest;
import com.walker.tcp.netty.DefaultLongConnection;
import com.walker.tcp.util.ConvertorUtils;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStringHandler
implements ServerHandler<Object> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String MSG_REQUEST_ERROR = "\u672a\u627e\u5230\u4efb\u4f55\u4f7f\u7528 TcpRequest \u6ce8\u89e3\u7684\u8bf7\u6c42\u5bf9\u8c61\uff0c\u65e0\u6cd5\u7ee7\u7eed\u6267\u884c\u6d88\u606f\u63a5\u6536";
    private int engineId;
    private ConnectionManager connectionManager;
    private boolean emtpyMsgDisconnect = false;
    private List<ProtocolResolver<?>> protocolResolverList;
    private Map<String, String> mapper = null;
    private QueueManager queueManager;
    private String connectionHost;

    public String getConnectionHost() {
        return this.connectionHost;
    }

    public void setConnectionHost(String connectionHost) {
        this.connectionHost = connectionHost;
    }

    public QueueManager getQueueManager() {
        return this.queueManager;
    }

    public void setQueueManager(QueueManager queueManager) {
        this.queueManager = queueManager;
    }

    public Map<String, String> getMapper() {
        return this.mapper;
    }

    public void setScanPackages(String scanPackages) {
        String[] packageNames;
        if (StringUtils.isNotEmpty((String)scanPackages) && (packageNames = scanPackages.split(",")) != null) {
            if (this.mapper == null) {
                this.mapper = new HashMap<String, String>();
            }
            Map<String, String> map = null;
            for (String p : packageNames) {
                map = ConvertorUtils.scanTcpRequestAnnotation(p);
                if (map == null) continue;
                this.mapper.putAll(map);
            }
        }
    }

    protected List<ProtocolResolver<?>> getProtocolResolverList() {
        return this.protocolResolverList;
    }

    public void setProtocolResolverList(List<ProtocolResolver<?>> protocolResolverList) {
        this.protocolResolverList = protocolResolverList;
    }

    @Override
    public void onConnected(String id) throws Exception {
    }

    @Override
    public void onDisConnected(String id) throws Exception {
        this.connectionManager.removeConnection(id);
    }

    @Override
    public void onRead(Connection conn, Object msg) throws Exception {
    }

    @Override
    public void onReadComplete(Object msg, String id, ChannelHandlerContext ctx) throws Exception {
        if (msg == null || StringUtils.isEmpty((String)msg.toString())) {
            if (this.emtpyMsgDisconnect) {
                Connection conn = this.connectionManager.getConnection(id);
                if (conn != null) {
                    conn.disconnect();
                }
                this.connectionManager.removeConnection(id);
                this.logger.warn("\u670d\u52a1\u7aef\u63a5\u6536\u5230\u5ba2\u6237\u7aef\u7a7a\u6570\u636e\uff0c\u53ef\u80fd\u7ec8\u7aef\u5f02\u5e38\u65ad\u5f00\uff0c\u670d\u52a1\u5668\u4e5f\u5c06\u5f3a\u5236\u65ad\u5f00\u3002id = " + id);
            }
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(msg.toString());
        }
        Request<?> request = null;
        ProtocolResolver<?> resolver = null;
        try {
            request = this.createRequest(msg.toString());
        }
        catch (Exception ex) {
            this.logger.error("\u521b\u5efatcp request\u5931\u8d25:" + msg, (Throwable)ex);
            return;
        }
        if (request == null) {
            this.logger.warn("\u6d88\u606f\u4e22\u5f03\uff0c\u4e1a\u52a1\u672a\u5b9a\u4e49\u8bf7\u6c42\u534f\u8bae\u5bf9\u8c61\uff1a" + msg);
            return;
        }
        resolver = ProtocolResolverPostProcessor.getProtocolResolver(request.getProtocolResolverId());
        Connection conn = this.connectionManager.getConnection(id);
        if (conn == null) {
            conn = new DefaultLongConnection(id, ctx);
            conn.setProtocolResolver(resolver);
            ((LongConnection)conn).setEngineId(this.engineId);
            ((LongConnection)conn).setLongConnection(true);
            conn.setConnectionHost(this.connectionHost);
        }
        if (conn.supportLongConnection() && conn.getAlreadyLogin() == 0) {
            try {
                String clientId = resolver.getAuthenticateInfo(request);
                conn.bindName(clientId);
                this.logger.debug("connection\u66f4\u65b0\u8ba4\u8bc1\uff1a" + conn.getName());
                this.connectionManager.putConnection(conn);
            }
            catch (AuthenticateException ae) {
                this.logger.error("\u8be5\u901a\u9053\u672a\u8ba4\u8bc1\u6210\u529f\uff0c\u5df2\u7ecf\u88ab\u65ad\u5f00\u8fde\u63a5\uff1a" + id, (Throwable)ae);
                this.logger.error("connection = {}", (Object)conn);
                conn.disconnect();
                this.connectionManager.removeConnection(id);
                return;
            }
        }
        AbstractStringRequest req = (AbstractStringRequest)request;
        req.setName(conn.getName());
        req.setSessionId(conn.getId());
        this.queueManager.push(request.getProtocolNum(), request, null);
    }

    protected abstract Request<?> createRequest(String var1) throws Exception;

    @Override
    public void onException(Throwable cause) throws Exception {
        if (cause instanceof IOException) {
            this.logger.warn("\u5ba2\u6237\u7aef\u8fde\u63a5\u5f02\u5e38\uff0c\u53ef\u80fd\u5df2\u7ecf\u65ad\u5f00");
        } else {
            this.logger.error(null, cause);
        }
    }

    @Override
    public int getEngineId() {
        return this.engineId;
    }

    public void setEngineId(int id) {
        this.engineId = id;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setConnectionManager(ConnectionManager manager) {
        this.connectionManager = manager;
    }

    @Override
    public void setEmptyMsgDisconnect(boolean result) {
        this.emtpyMsgDisconnect = result;
    }

    public boolean isEmtpyMsgDisconnect() {
        return this.emtpyMsgDisconnect;
    }
}

