/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.handler;

import com.walker.infrastructure.utils.ClassUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.tcp.Request;
import com.walker.tcp.data.AbstractStringRequest;
import com.walker.tcp.handler.AbstractStringHandler;
import com.walker.tcp.protocol.StringProtocolResolver;
import com.walker.tcp.util.ConvertorUtils;

public class LongHandler
extends AbstractStringHandler {
    public LongHandler() {
        this.setEmptyMsgDisconnect(true);
    }

    @Override
    protected Request<?> createRequest(String msg) throws Exception {
        if (this.getMapper() == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u4efb\u4f55\u4f7f\u7528 TcpRequest \u6ce8\u89e3\u7684\u8bf7\u6c42\u5bf9\u8c61\uff0c\u65e0\u6cd5\u7ee7\u7eed\u6267\u884c\u6d88\u606f\u63a5\u6536");
        }
        StringProtocolResolver resolver = (StringProtocolResolver)ConvertorUtils.getProtocolResolver(msg, this.getProtocolResolverList());
        if (resolver == null) {
            throw new IllegalArgumentException("protocolResolver not found, msg : " + msg);
        }
        String content = msg.substring(0, msg.length() - resolver.getDelimiter().length());
        String protocol = resolver.getProtocolNum(content, content.length());
        String clazz = this.getMapper().get(protocol);
        if (StringUtils.isEmpty((String)clazz)) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u534f\u8bae\u5bf9\u5e94\u7684request\u7c7b\u4e0d\u5b58\u5728\u3002protocol = " + protocol + ", msg = " + content);
        }
        try {
            Class clazzRequest = ClassUtils.forName((String)clazz, (ClassLoader)this.getClass().getClassLoader());
            AbstractStringRequest request = (AbstractStringRequest)clazzRequest.newInstance();
            request.fromSource(content);
            request.setProtocolResolverId(resolver.getOrder());
            return request;
        }
        catch (ClassNotFoundException e) {
            this.logger.error("\u6839\u636e\u6620\u5c04\u521b\u5efarequest\u5bf9\u8c61\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }
}

