/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.lb;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.tcp.Connection;
import com.walker.tcp.lb.LongConnectionMeta;
import com.walker.tcp.lb.RedisConnectionMetaCache;
import com.walker.tcp.lb.RedisConnectionNameCache;
import com.walker.tcp.lb.ResponseWriter;
import com.walker.tcp.support.AbstractConnectionManager;
import com.walker.tcp.support.MemoryConnectionCache;
import java.util.List;

public abstract class LoadBalanceConnectionManager
extends AbstractConnectionManager {
    private ResponseWriter responseWriter;
    private RedisConnectionMetaCache connectionMetaCache;
    private RedisConnectionNameCache connectionNameCache;
    private String connectionHost;

    public LoadBalanceConnectionManager() {
        this.setConnectionCache(new MemoryConnectionCache());
    }

    @Override
    protected void onSaveConnection(Connection connection) throws Exception {
        if (StringUtils.isEmpty((String)this.connectionHost)) {
            throw new IllegalArgumentException("LoadBalanceConnectionManager\u672a\u914d\u7f6e\u4e3b\u673a\u6807\u8bc6");
        }
        String savedConnectionHost = connection.getConnectionHost();
        if (StringUtils.isEmpty((String)savedConnectionHost)) {
            throw new IllegalArgumentException("connection\u672a\u5305\u542b\u4e3b\u673a\u6807\u8bc6");
        }
        if (!this.connectionHost.equals(savedConnectionHost)) {
            throw new IllegalArgumentException("savedConnectionHost\u4e0e\u5f53\u524d\u4e3b\u673a\u4e0d\u5339\u914d\uff1a" + savedConnectionHost + ", connectionHost" + this.connectionHost);
        }
        this.doSaveConnectionMeta(connection);
    }

    @Override
    protected void onUpdateConnection(Connection connection) throws Exception {
        this.doSaveConnectionMeta(connection);
    }

    private void doSaveConnectionMeta(Connection connection) {
        LongConnectionMeta connectionMeta = this.acquireConnectionMeta(connection);
        if (connectionMeta == null) {
            throw new AbstractMethodError("\u8bf7\u5b9e\u73b0\u62bd\u8c61\u65b9\u6cd5\uff1aacquireConnectionMeta");
        }
        this.connectionMetaCache.putConnectionMeta(connectionMeta);
        this.connectionNameCache.putConnectionName(connection.getName(), connection.getId());
    }

    @Override
    protected void onDeleteConnection(int engineId, String name) throws Exception {
        String id = this.connectionNameCache.getConnectionId(name);
        if (StringUtils.isEmpty((String)id)) {
            this.logger.warn("\u6839\u636e\u8fde\u63a5\u540d\u79f0\u672a\u627e\u5230id\uff0cname={}", (Object)name);
            return;
        }
        this.connectionMetaCache.removeConnectionMeta(id);
        this.connectionNameCache.removeConnectionName(name);
    }

    @Override
    protected void onUpdateLastTime(int engineId, String id, long lastTime) throws Exception {
    }

    @Override
    public Connection getConnection(String id) {
        Connection connection = super.getConnection(id);
        if (connection == null) {
            this.logger.debug("connection\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u662f\u5176\u4ed6\u8282\u70b9\u4e2d\uff0c\u7ee7\u7eed\u67e5\u627e\u3002id={}", (Object)id);
            LongConnectionMeta connectionMeta = this.connectionMetaCache.getConnectionMeta(id);
            if (connectionMeta == null) {
                this.logger.debug("connectionMeta\u4e5f\u672a\u627e\u5230\uff0cid={}", (Object)id);
                return null;
            }
            connectionMeta.setResponseWriter(this.responseWriter);
            return connectionMeta;
        }
        return connection;
    }

    @Override
    public Connection getConnectionByName(String name) {
        Connection connection = super.getConnectionByName(name);
        if (connection == null) {
            this.logger.debug("connection\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u662f\u5176\u4ed6\u8282\u70b9\u4e2d\uff0c\u7ee7\u7eed\u67e5\u627e\u3002name={}", (Object)name);
            String id = this.connectionNameCache.getConnectionId(name);
            if (StringUtils.isEmpty((String)id)) {
                this.logger.debug("\u901a\u8fc7name\u672a\u627e\u5230\u8fde\u63a5id, name = {}", (Object)name);
                return null;
            }
            LongConnectionMeta connectionMeta = this.connectionMetaCache.getConnectionMeta(id);
            if (connectionMeta == null) {
                this.logger.debug("connectionMeta\u4e5f\u672a\u627e\u5230\uff0cid={}", (Object)id);
                return null;
            }
            connectionMeta.setResponseWriter(this.responseWriter);
            return connectionMeta;
        }
        return connection;
    }

    @Override
    public List<Connection> queryAllConnectionListBy(int engineId) {
        throw new UnsupportedOperationException("\u8d1f\u8f7d\u73af\u5883\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff1aqueryAllConnectionListBy(enginId)");
    }

    protected abstract LongConnectionMeta acquireConnectionMeta(Connection var1);

    public String getConnectionHost() {
        return this.connectionHost;
    }

    public void setConnectionHost(String connectionHost) {
        this.connectionHost = connectionHost;
    }

    public RedisConnectionMetaCache getConnectionMetaCache() {
        return this.connectionMetaCache;
    }

    public void setConnectionMetaCache(RedisConnectionMetaCache connectionMetaCache) {
        this.connectionMetaCache = connectionMetaCache;
    }

    public RedisConnectionNameCache getConnectionNameCache() {
        return this.connectionNameCache;
    }

    public void setConnectionNameCache(RedisConnectionNameCache connectionNameCache) {
        this.connectionNameCache = connectionNameCache;
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
    }

    public ResponseWriter getResponseWriter() {
        return this.responseWriter;
    }
}

