/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.lb;

import com.walker.support.redis.cache.RedisCacheProvider;
import com.walker.tcp.lb.LongConnectionMeta;

public class RedisConnectionMetaCache
extends RedisCacheProvider<LongConnectionMeta> {
    private long expiredSeconds = 7200L;

    public RedisConnectionMetaCache() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    public LongConnectionMeta getConnectionMeta(String id) {
        return (LongConnectionMeta)this.getCacheData(id);
    }

    public void removeConnectionMeta(String id) {
        this.removeCacheData(id);
    }

    public void putConnectionMeta(LongConnectionMeta connectionMeta) {
        this.putCacheData(connectionMeta.getId(), connectionMeta, this.expiredSeconds);
    }

    @Deprecated
    private String getKey(String connectionHost, String id) {
        return connectionHost + ":" + id;
    }

    public String getProviderName() {
        return "cache.tcp.connect.meta";
    }

    public Class<?> getProviderType() {
        return LongConnectionMeta.class;
    }

    public long getExpiredSeconds() {
        return this.expiredSeconds;
    }

    public void setExpiredSeconds(long expiredSeconds) {
        this.expiredSeconds = expiredSeconds;
    }
}

