/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.netty;

import com.walker.tcp.ConnectionManager;
import com.walker.tcp.ServerHandler;
import com.walker.tcp.netty.DefaultLongConnection;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannelInBoundHandler<T>
extends SimpleChannelInboundHandler<T> {
    protected final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected ServerHandler<T> tcpServerHandler;
    protected ConnectionManager connectionManager;
    protected final ThreadLocal<T> msgThreadLocal = new ThreadLocal();

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setTcpServerHandler(ServerHandler<T> tcpServerHandler) {
        this.tcpServerHandler = tcpServerHandler;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.logger.debug("ChannelHandlerContext = {}", (Object)ctx.getClass().getName());
        String id = ctx.channel().id().asLongText();
        DefaultLongConnection conn = (DefaultLongConnection)this.connectionManager.getConnection(id);
        if (conn != null) {
            if (conn.isAuthenticated() && conn.getName() != null) {
                conn.setChannelHandlerContext(ctx);
                conn.setLastTime(System.currentTimeMillis());
                this.connectionManager.updateConnection(id, conn);
                this.logger.debug("channelActive\uff0c\u8fde\u63a5\u5df2\u7ecf\u5b58\u5728\uff0c\u66f4\u65b0\u65f6\u95f4\uff1a" + conn.getName());
                return;
            }
            this.logger.debug("\u8fde\u63a5\u5df2\u7ecf\u5b58\u5728\uff0c\u4f46\u5df2\u7ecf\u8fc7\u671f\uff0c\u5220\u9664\u540e\u4f1a\u91cd\u65b0\u7f13\u5b58\u3002id = " + id);
            this.connectionManager.removeConnection(id);
        }
        this.tcpServerHandler.onConnected(id);
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        String id = ctx.channel().id().asLongText();
        this.tcpServerHandler.onDisConnected(id);
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.tcpServerHandler.onException(cause);
        super.exceptionCaught(ctx, cause);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        String id = ctx.channel().id().asLongText();
        this.logger.debug("\u6267\u884c\u4e86\u65b9\u6cd5\uff1ahandlerRemoved()\uff0c\u8fde\u63a5\u88ab\u5220\u9664\u3002id = " + id);
        this.tcpServerHandler.onDisConnected(id);
        super.channelInactive(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent event = (IdleStateEvent)evt;
            if (event.state().equals((Object)IdleState.READER_IDLE)) {
                String id = ctx.channel().id().asLongText();
                try {
                    this.tcpServerHandler.onDisConnected(id);
                    this.logger.warn("\u901a\u9053\u8d85\u65f6\u672a\u8bf7\u6c42\u6570\u636e\uff0c\u88ab\u5f3a\u5236\u5173\u95ed\uff0cid\uff1a" + id);
                }
                catch (Exception e) {
                    this.logger.error("\u901a\u9053\u8d85\u65f6\u672a\u8bf7\u6c42\u6570\u636e\uff0c\u88ab\u5f3a\u5236\u5173\u95ed\uff0c\u4f46\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                }
            } else if (!event.state().equals((Object)IdleState.WRITER_IDLE) && event.state().equals((Object)IdleState.ALL_IDLE)) {
                this.logger.debug("------ALL_IDLE");
            }
        }
    }
}

