/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.netty;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.tcp.ProtocolResolver;
import com.walker.tcp.netty.DefaultLongHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServerInitializer
extends ChannelInitializer<SocketChannel> {
    protected final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private DefaultLongHandler handler;
    private boolean showLog = false;
    private List<ProtocolResolver<?>> protocolResolverList;
    private int timeOutRead = 0;
    private int timeOutWrite = 0;
    private int timeOutAll = 0;

    public void setShowLog(boolean showLog) {
        this.showLog = showLog;
    }

    public void setTimeOutRead(int timeOutRead) {
        this.timeOutRead = timeOutRead;
    }

    public void setTimeOutWrite(int timeOutWrite) {
        this.timeOutWrite = timeOutWrite;
    }

    public void setTimeOutAll(int timeOutAll) {
        this.timeOutAll = timeOutAll;
    }

    public void setProtocolResolverList(List<ProtocolResolver<?>> protocolResolverList) {
        this.protocolResolverList = protocolResolverList;
    }

    public void setHandler(DefaultLongHandler handler) {
        this.handler = handler;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        this.logger.debug("SocketChannel = {}", (Object)ch.getClass().getName());
        ChannelPipeline pipeline = ch.pipeline();
        if (this.showLog) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler(LogLevel.INFO));
        }
        this.initProtocolResolvers(pipeline);
        pipeline.addLast("decoder", (ChannelHandler)new StringDecoder());
        pipeline.addLast("encoder", (ChannelHandler)new StringEncoder());
        pipeline.addLast(new ChannelHandler[]{new IdleStateHandler((long)this.timeOutRead, (long)this.timeOutWrite, (long)this.timeOutAll, TimeUnit.SECONDS)});
        pipeline.addLast("handler", (ChannelHandler)this.handler);
    }

    protected void initProtocolResolvers(ChannelPipeline pipeline) {
        if (StringUtils.isEmptyList(this.protocolResolverList)) {
            throw new IllegalStateException("\u7cfb\u7edf\u672a\u914d\u7f6e\u4efb\u4f55ProtocolResolver\u5bf9\u8c61\uff0c\u65e0\u6cd5\u89e3\u6790\u62a5\u6587");
        }
        ByteBuf[] decoderFrames = new ByteBuf[this.protocolResolverList.size()];
        for (int i = 0; i < this.protocolResolverList.size(); ++i) {
            this.logger.info("\u670d\u52a1\u7aef\u8bbe\u7f6e\u4e86\u5206\u9694\u7b26\uff1a" + this.protocolResolverList.get(i).getDelimiter());
            decoderFrames[i] = Unpooled.wrappedBuffer((byte[])this.protocolResolverList.get(i).getDelimiter().getBytes());
        }
        pipeline.addLast("framer", (ChannelHandler)new DelimiterBasedFrameDecoder(8192, false, decoderFrames));
    }

    public DefaultLongHandler getHandler() {
        return this.handler;
    }
}

