/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.netty;

import com.walker.tcp.netty.DefaultServerInitializer;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.stream.ChunkedWriteHandler;

public class WebSocketServerInitializer
extends DefaultServerInitializer {
    @Override
    protected void initChannel(SocketChannel ch) throws Exception {
        this.logger.debug("SocketChannel = {}", (Object)ch.getClass().getName());
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("logging", (ChannelHandler)new LoggingHandler(LogLevel.INFO));
        pipeline.addLast("http-codec", (ChannelHandler)new HttpServerCodec());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
        pipeline.addLast("http-chunked", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("handler", (ChannelHandler)this.getHandler());
    }
}

