/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.protocol;

import com.walker.tcp.ProtocolException;
import com.walker.tcp.ProtocolResolver;
import com.walker.tcp.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProtocolResolver<T>
implements ProtocolResolver<T> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String name;
    private Object feature;
    private String delimiter;
    private int order = 0;
    private Response<?> heartBeatResponse = null;
    private boolean permitNotRegisterConnect = false;

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProtocolFeature(Object feature) {
        this.feature = feature;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProtocolNum(T data, int size) throws ProtocolException {
        return this.onResolve(data, size);
    }

    @Override
    public Object getProtocolFeature() {
        return this.feature;
    }

    @Override
    public String getDelimiter() {
        return this.delimiter;
    }

    protected abstract String onResolve(T var1, int var2) throws ProtocolException;

    @Override
    public boolean isRequireFeatureResolve() {
        return false;
    }

    public boolean getRequireFeatureResolve() {
        return this.isRequireFeatureResolve();
    }

    @Override
    public Response<?> getHeartBeatResponse() {
        if (this.heartBeatResponse == null) {
            this.heartBeatResponse = this.doCreateOneResponse();
        }
        return this.heartBeatResponse;
    }

    protected abstract Response<?> doCreateOneResponse();

    public void setPermitNotRegisterConnect(boolean permitNotRegisterConnect) {
        this.permitNotRegisterConnect = permitNotRegisterConnect;
    }

    @Override
    public boolean isPermitNotRegisterConnect() {
        return this.permitNotRegisterConnect;
    }

    protected boolean isRegistered(String clientId) {
        return true;
    }

    @Override
    public boolean isOnlyMatchFeature() {
        return false;
    }
}

