/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.support;

import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.security.SystemLogMan;
import com.walker.tcp.Connection;
import com.walker.tcp.ConnectionCache;
import com.walker.tcp.ConnectionManager;
import com.walker.tcp.connect.AbstractConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionManager
implements ConnectionManager {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String TIP_NULL_CONNECTION = "\u4e0d\u80fd\u653e\u5165\u7a7aconnection";
    private boolean multipleEngine = false;
    private Map<Integer, String> connectionTypeCache = new ConcurrentHashMap<Integer, String>();
    private ConnectionCache connectionCache;

    public void setConnectionTypeMap(Map<Integer, String> connectionTypes) {
        if (connectionTypes != null) {
            this.connectionTypeCache = connectionTypes;
        }
        SystemLogMan.getInstance().checkMan();
    }

    public void setMultipleEngine(boolean multipleEngine) {
        this.multipleEngine = multipleEngine;
    }

    @Override
    public boolean isSupportMultipleEngine() {
        return this.multipleEngine;
    }

    @Override
    public void putConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException(TIP_NULL_CONNECTION);
        }
        String name = connection.getName();
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("connection\u5bf9\u8c61\u672a\u8bbe\u7f6ename\u5c5e\u6027\uff0c\u4e1a\u52a1\u5c06\u65e0\u6cd5\u4f7f\u7528");
        }
        String oldId = this.connectionCache.getIdByName(name);
        if (StringUtils.isNotEmpty((String)oldId)) {
            this.logger.warn("\u7ec8\u7aef\u8bbe\u5907\u5728\u672a\u65ad\u5f00\u8fde\u63a5\u7684\u60c5\u51b5\u4e0b\uff0c\u91cd\u65b0\u767b\u5f55\u6ce8\u518c\uff1a" + name + ", \u5220\u9664\u8001\u8fde\u63a5\uff1a" + oldId);
            this.connectionCache.removeConnection(oldId);
        }
        this.connectionCache.putConnection(connection);
        try {
            this.onSaveConnection(connection);
        }
        catch (Exception e) {
            this.logger.error("\u4e1a\u52a1\u8c03\u7528\u6301\u4e45\u5316\u8fde\u63a5\u9519\u8bef:" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void updateConnection(String id, Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException(TIP_NULL_CONNECTION);
        }
        ((AbstractConnection)connection).setLastTime(System.currentTimeMillis());
        this.connectionCache.updateConnection(connection);
        try {
            this.onUpdateConnection(connection);
            this.onUpdateLastTime(connection.getEngineId(), connection.getName(), connection.getLastTime());
        }
        catch (Exception e) {
            this.logger.error("\u4e1a\u52a1\u66f4\u65b0\u6301\u4e45\u5316\u8fde\u63a5\u9519\u8bef:" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void removeConnection(String id) {
        Connection conn = this.connectionCache.getConnection(id);
        if (conn != null) {
            try {
                this.onDeleteConnection(conn.getEngineId(), conn.getName());
            }
            catch (Exception e) {
                this.logger.error("\u4e1a\u52a1\u5220\u9664\u6301\u4e45\u5316\u8fde\u63a5\u9519\u8bef:" + e.getMessage(), (Throwable)e);
            }
        }
        this.connectionCache.removeConnection(id);
    }

    @Override
    public void removeConnectionByName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name is required!");
        }
        String id = this.connectionCache.getIdByName(name);
        if (id == null) {
            this.logger.warn("\u6839\u636e\u7ec8\u7aef\u540d\u79f0\u67e5\u627e\u901a\u9053ID\u9519\u8bef\uff1a\u672a\u627e\u5230name=" + name);
            return;
        }
        this.connectionCache.removeConnection(id);
        try {
            this.onDeleteConnection(0, name);
        }
        catch (Exception e) {
            this.logger.error("\u4e1a\u52a1\u5220\u9664\u6301\u4e45\u5316\u8fde\u63a5\u9519\u8bef:" + e.getMessage() + ", name=" + name, (Throwable)e);
        }
    }

    @Override
    public void updateLastTime(String id) {
        Connection conn = this.connectionCache.getConnection(id);
        if (conn != null) {
            ((AbstractConnection)conn).setLastTime(System.currentTimeMillis());
        }
    }

    @Override
    public Connection getConnection(String id) {
        return this.connectionCache.getConnection(id);
    }

    @Override
    public void putConnection(int engineId, Connection connection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateConnection(int engineId, String id, Connection connection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeConnection(int engineId, String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLastTime(int engineId, String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Connection getConnection(int engineId, String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public GenericPager<Connection> queryPageConnectionList(int pageIndex, int pageSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Connection> queryAllConnectionList() {
        return this.connectionCache.getAllConnectionList();
    }

    @Override
    public Map<Integer, String> getConnectionTypeMap() {
        return this.connectionTypeCache;
    }

    @Override
    public String getConnectionTypeName(int engineId) {
        return this.connectionTypeCache.get(engineId);
    }

    @Override
    public List<Connection> queryAllConnectionListBy(int engineId) {
        ArrayList<Connection> result = new ArrayList<Connection>();
        for (Connection conn : this.connectionCache.getAllConnectionList()) {
            if (conn.getEngineId() != engineId) continue;
            result.add(conn);
        }
        return result;
    }

    @Override
    public Connection getConnectionByName(String name) {
        return this.connectionCache.getConnectionByName(name);
    }

    protected abstract void onSaveConnection(Connection var1) throws Exception;

    protected abstract void onDeleteConnection(int var1, String var2) throws Exception;

    protected abstract void onUpdateLastTime(int var1, String var2, long var3) throws Exception;

    protected abstract void onUpdateConnection(Connection var1) throws Exception;

    public ConnectionCache getConnectionCache() {
        return this.connectionCache;
    }

    public void setConnectionCache(ConnectionCache connectionCache) {
        this.connectionCache = connectionCache;
    }
}

