/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.util;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.tcp.Message;
import com.walker.tcp.ProtocolResolver;
import com.walker.tcp.TcpRequest;
import com.walker.tcp.protocol.MessageProtocolResolver;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ConvertorUtils {
    public static Map<String, String> scanTcpRequestAnnotation(String packageName) {
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        Set classesList = reflections.getTypesAnnotatedWith(TcpRequest.class);
        if (classesList != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            TcpRequest annotation = null;
            for (Class c : classesList) {
                annotation = c.getAnnotation(TcpRequest.class);
                if (annotation == null) continue;
                if (StringUtils.isEmpty((String)annotation.value())) {
                    throw new IllegalArgumentException("TcpRequest\u6ce8\u89e3\u6ca1\u6709\u8bbe\u7f6evalue\uff0c\u5fc5\u987b\u914d\u7f6e\u3002class = " + c.getName());
                }
                map.put(annotation.value(), c.getName());
            }
            return map;
        }
        return null;
    }

    public static final ProtocolResolver<?> getProtocolResolver(Object msg, List<ProtocolResolver<?>> resolverList) {
        if (msg == null) {
            throw new IllegalArgumentException("msg(Object) is required!");
        }
        Object feature = null;
        String msgStr = null;
        for (ProtocolResolver<?> pr : resolverList) {
            if (msg instanceof Message) {
                Message message = (Message)msg;
                if (pr.isOnlyMatchFeature()) {
                    if (pr instanceof MessageProtocolResolver) {
                        feature = pr.getProtocolFeature();
                        if (feature == null || !Arrays.equals(message.getFeature(), (byte[])feature)) continue;
                        return pr;
                    }
                    throw new UnsupportedOperationException("\u9700\u8981\u6269\u5c55\u62a5\u6587\u89e3\u6790\u7c7b\u578b\uff1a" + message.toString());
                }
                throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u7684\u62a5\u6587\u89e3\u6790\u7c7b\u578b\uff1a" + message.toString());
            }
            if (pr instanceof MessageProtocolResolver || !(msgStr = msg.toString()).endsWith(pr.getDelimiter())) continue;
            if (pr.isRequireFeatureResolve()) {
                if (pr.getProtocolFeature() == null) {
                    throw new IllegalArgumentException("\u62a5\u6587\u89e3\u6790\u9700\u8981\u524d\u7f00\u7279\u5f81\uff0c\u4f46\u8be5\u89e3\u6790\u5668\u672a\u5b9a\u4e49\u7279\u5f81\u3002" + pr.getName());
                }
                if (!msgStr.startsWith(pr.getProtocolFeature().toString())) continue;
                return pr;
            }
            return pr;
        }
        return null;
    }

    public static void main(String[] args) {
        Map<String, String> map = ConvertorUtils.scanTcpRequestAnnotation("com.walker.tcp");
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            System.out.println(entry.getKey() + ", " + entry.getValue());
        }
    }
}

