/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.websocket;

import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.ClassUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.tcp.Request;
import com.walker.tcp.data.AbstractStringRequest;
import com.walker.tcp.handler.LongHandler;
import com.walker.tcp.protocol.StringProtocolResolver;
import com.walker.tcp.websocket.WebsocketProtocolResolver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WebsocketHandler
extends LongHandler {
    private final StringProtocolResolver resolver = new WebsocketProtocolResolver();
    private Map<String, Class<?>> requestClazzCache = new ConcurrentHashMap();

    @Override
    protected Request<?> createRequest(String content) throws Exception {
        if (this.getMapper() == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u4efb\u4f55\u4f7f\u7528 TcpRequest \u6ce8\u89e3\u7684\u8bf7\u6c42\u5bf9\u8c61\uff0c\u65e0\u6cd5\u7ee7\u7eed\u6267\u884c\u6d88\u606f\u63a5\u6536");
        }
        String protocol = this.resolver.getProtocolNum(content, content.length());
        String clazz = this.getMapper().get(protocol);
        if (StringUtils.isEmpty((String)clazz)) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u534f\u8bae\u5bf9\u5e94\u7684request\u7c7b\u4e0d\u5b58\u5728\u3002protocol = " + protocol + ", msg = " + content);
        }
        Class<?> clazzRequest = this.acquireRequestClazz(clazz);
        AbstractStringRequest request = (AbstractStringRequest)clazzRequest.newInstance();
        request.fromSource(content);
        request.setProtocolResolverId(this.resolver.getOrder());
        return request;
    }

    private Class<?> acquireRequestClazz(String clazz) {
        if (StringUtils.isEmpty((String)clazz)) {
            throw new IllegalArgumentException("\u5fc5\u987b\u63d0\u4f9b\u8bf7\u6c42\u5bf9\u8c61class\u540d\u79f0!");
        }
        Class requestClazz = this.requestClazzCache.get(clazz);
        if (requestClazz == null) {
            try {
                requestClazz = ClassUtils.forName((String)clazz, (ClassLoader)this.getClass().getClassLoader());
                this.requestClazzCache.put(clazz, requestClazz);
            }
            catch (ClassNotFoundException e) {
                throw new ApplicationRuntimeException("tcp request class not found: " + clazz, (Throwable)e);
            }
        }
        return requestClazz;
    }
}

