/*
 * Decompiled with CFR 0.152.
 */
package com.walker.tcp.websocket;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.tcp.AuthenticateException;
import com.walker.tcp.ProtocolException;
import com.walker.tcp.Request;
import com.walker.tcp.Response;
import com.walker.tcp.protocol.StringProtocolResolver;
import com.walker.tcp.websocket.JsonResponse;
import java.util.Map;

public class WebsocketProtocolResolver
extends StringProtocolResolver {
    public WebsocketProtocolResolver() {
        this.setName("Websocket\u534f\u8bae\u89e3\u6790\u5668\u3010\u5185\u7f6e\u3011");
        this.setOrder(10);
    }

    @Override
    @JsonIgnore
    protected String onResolve(String source, int size) throws ProtocolException {
        if (StringUtils.isEmpty((String)source)) {
            return null;
        }
        ObjectNode json = null;
        try {
            json = JsonUtils.jsonStringToObjectNode((String)source);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (json == null || !json.has("protocol")) {
            throw new IllegalArgumentException("\u975e\u6cd5\u62a5\u6587\u683c\u5f0f\uff0c\u8bf7\u4f7f\u7528json\uff0c\u5e76\u5e26\u6709protocol\u5c5e\u6027");
        }
        return json.get("protocol").asText();
    }

    @Override
    @JsonIgnore
    protected Response<?> doCreateOneResponse() {
        return new WebSocketHeartBeatResponse();
    }

    @Override
    @JsonIgnore
    public String getAuthenticateInfo(Request<?> request) throws AuthenticateException {
        String clientId;
        if (this.logger.isDebugEnabled()) {
            try {
                this.logger.debug("\u9700\u8981\u8ba4\u8bc1\u8bf7\u6c42\uff1a{}", (Object)JsonUtils.objectToJsonString(request));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isEmpty((String)(clientId = request.getName()))) {
            throw new AuthenticateException("\u8bf7\u6c42\u4fe1\u606f\u4e2d\u4e0d\u5b58\u5728\u8bbe\u5907ID\u53f7\uff0c\u65e0\u6cd5\u8ba4\u8bc1");
        }
        if (!this.isPermitNotRegisterConnect() && !this.isRegistered(clientId)) {
            throw new AuthenticateException("\u8bbe\u5907\u672a\u5728\u5217\u8868\u4e2d\u6ce8\u518c\uff0c\u65e0\u6cd5\u8ba4\u8bc1\u3002clientId = " + clientId);
        }
        return clientId;
    }

    private class WebSocketHeartBeatResponse
    extends JsonResponse {
        private static final long serialVersionUID = 775725794320035005L;

        private WebSocketHeartBeatResponse() {
        }

        @Override
        protected void translateProperties(Map<String, Object> result) {
        }

        @Override
        public String getProtocolNum() {
            return "heartbeat";
        }

        @Override
        public String getDelimiter() {
            return "";
        }
    }
}

