/*
 * Decompiled with CFR 0.152.
 */
package com.walker.semantics;

import com.walker.semantics.util.SemanticsUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class OwnerTextStore
implements Serializable {
    private String owner;
    private final Map<String, String> idAndTextCache = new HashMap<String, String>(256);
    private final Map<String, Integer[]> idAndWordHashCache = new HashMap<String, Integer[]>(256);

    public String getWord(String id) {
        return this.idAndTextCache.get(id);
    }

    public Integer[] getWordHashCode(String id) {
        return this.idAndWordHashCache.get(id);
    }

    public void putWord(String id, String words) {
        this.idAndWordHashCache.put(id, SemanticsUtils.acquireWordHashCode(words));
        this.idAndTextCache.put(id, words);
    }

    public String getOwner() {
        return this.owner;
    }

    public OwnerTextStore(String owner) {
        this.owner = owner;
    }

    public Map<String, String> getIdAndTextCache() {
        return this.idAndTextCache;
    }

    public Map<String, Integer[]> getIdAndWordHashCache() {
        return this.idAndWordHashCache;
    }
}

