/*
 * Decompiled with CFR 0.152.
 */
package com.walker.semantics;

import com.walker.semantics.SpeechPart;

public class WordMeta {
    private String text;
    private SpeechPart speechPart = null;
    private int index = 0;
    private boolean duplication = false;

    public boolean isDuplication() {
        return this.duplication;
    }

    public void setDuplication(boolean duplication) {
        this.duplication = duplication;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public WordMeta(String text, SpeechPart speechPart) {
        if (text == null || text.equals("") || speechPart == null) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u53c2\u6570\uff1atext | speechPart");
        }
        this.text = text;
        this.speechPart = speechPart;
    }

    public String getText() {
        return this.text;
    }

    public SpeechPart getSpeechPart() {
        return this.speechPart;
    }

    public boolean isMyName() {
        return this.speechPart == SpeechPart.MY_N;
    }

    public boolean isMyPlace() {
        return this.speechPart == SpeechPart.MY_PLACE;
    }

    public boolean isMyRoad() {
        return this.speechPart == SpeechPart.MY_ROAD;
    }

    public boolean isPlace() {
        return this.speechPart == SpeechPart.MY_PLACE || this.speechPart == SpeechPart.NS_PLACENAME || this.speechPart == SpeechPart.S_PLACE;
    }

    public boolean isInstruction() {
        return this.speechPart == SpeechPart.MY_V;
    }

    public boolean isInstructionAuxiliary() {
        return this.speechPart == SpeechPart.MY_V_AUX;
    }

    public boolean isResource() {
        return this.speechPart == SpeechPart.MY_N || this.isMyPlace() || this.isMyRoad();
    }

    public boolean isAvailableInstruction() {
        return this.speechPart == SpeechPart.V_VERB || this.speechPart == SpeechPart.VN_VERBNAME || this.speechPart == SpeechPart.N_NAME || this.speechPart == SpeechPart.RYS;
    }

    public boolean isVerbs() {
        return this.speechPart == SpeechPart.V_VERB || this.speechPart == SpeechPart.VN_VERBNAME;
    }

    public boolean isPreposition() {
        return this.speechPart == SpeechPart.P_PREPOSITION;
    }

    public boolean isF_Position() {
        return this.speechPart == SpeechPart.F_POSITION;
    }

    public boolean isTime() {
        return this.speechPart == SpeechPart.T_TIME;
    }

    public boolean isNumber() {
        return this.speechPart == SpeechPart.M_NUMBER;
    }

    public boolean isMQ() {
        return this.speechPart == SpeechPart.MQ_NUMBER_UNIT;
    }

    public boolean isQ() {
        return this.speechPart == SpeechPart.Q_QUANTIFIER || this.speechPart == SpeechPart.QV;
    }

    public boolean isQuantity() {
        return this.speechPart == SpeechPart.M_NUMBER || this.speechPart == SpeechPart.MQ_NUMBER_UNIT;
    }

    @Deprecated
    public boolean isM() {
        return this.speechPart == SpeechPart.M_NUMBER;
    }

    public boolean isAdjective() {
        return this.speechPart == SpeechPart.A_ADJECTIVE;
    }

    public boolean isName() {
        return this.speechPart == SpeechPart.N_NAME || this.speechPart == SpeechPart.VN_VERBNAME;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof WordMeta) {
            WordMeta wm = (WordMeta)obj;
            if (wm.text.equals(this.text)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public String toString() {
        return "[text=" + this.text + ", speechPart=" + (Object)((Object)this.speechPart) + "]";
    }
}

