/*
 * Decompiled with CFR 0.152.
 */
package com.walker.semantics.support;

import com.walker.semantics.SemanticsException;
import com.walker.semantics.SemanticsManager;
import com.walker.semantics.SpeechPart;
import org.ansj.domain.Result;
import org.ansj.library.DicLibrary;
import org.ansj.splitWord.analysis.DicAnalysis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSemanticsManager
implements SemanticsManager {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void startup() {
        this.loadKeywordFromPersistence();
    }

    @Override
    public void registerKeyWord(int sceneContextId, String word, SpeechPart speechPart) throws SemanticsException {
        Result result = DicAnalysis.parse((String)word);
        int wordSize = result.getTerms().size();
        if (wordSize == 0) {
            throw new SemanticsException("\u6ce8\u518c\u7684\u5173\u952e\u8bcd\u4e3a\u7a7a\uff1a" + word);
        }
        boolean syncToVoice = false;
        if (speechPart == SpeechPart.MY_V) {
            DicLibrary.insert((String)"dic", (String)word, (String)"mv", (int)1000);
        } else if (speechPart == SpeechPart.MY_N) {
            DicLibrary.insert((String)"dic", (String)word, (String)"mn", (int)1000);
        } else if (speechPart == SpeechPart.MY_PLACE) {
            DicLibrary.insert((String)"dic", (String)word, (String)"mp", (int)100);
        } else if (speechPart == SpeechPart.MY_V_AUX) {
            DicLibrary.insert((String)"dic", (String)word, (String)"mv_aux", (int)1000);
        } else if (speechPart == SpeechPart.MY_ROAD) {
            DicLibrary.insert((String)"dic", (String)word, (String)"mr", (int)200);
        } else {
            throw new SemanticsException("\u6ce8\u518c\u5173\u952e\u8bcd\u672a\u652f\u6301\u7c7b\u578b\uff1a" + speechPart.name());
        }
        this.afterRegisterKeyWord(word, speechPart);
        if (syncToVoice) {
            this.logger.info("\u5df2\u540c\u6b65\u5230\u8bed\u97f3\u5e93\uff1a" + word);
        }
    }

    @Override
    public void removeKeyWord(int sceneContextId, String word) {
        DicLibrary.delete((String)"dic", (String)word);
    }

    protected void loadKeywordFromPersistence() {
        DicLibrary.insert((String)"dic", (String)"\u76d6\u4e9a", (String)"mn", (int)1000);
        DicLibrary.insert((String)"dic", (String)"\u524d\u5929", (String)"t", (int)1000);
        DicLibrary.insert((String)"dic", (String)"\u540e\u5929", (String)"t", (int)1000);
        DicLibrary.insert((String)"dic", (String)"\u5927\u540e\u5929", (String)"t", (int)1000);
    }

    protected void afterRegisterKeyWord(String text, SpeechPart speechPart) {
    }

    protected void afterRemoveKeyWord(String text) {
    }
}

