package com.walker.semantics;

import com.walker.infrastructure.ApplicationException;

public class ExtractorException extends ApplicationException {

    public ExtractorException(String msg){
        super(msg);
    }

    public ExtractorException(String msg, String source, Throwable caution){
        super(msg, caution);
        this.source = source;
    }
    public ExtractorException(String msg, String source, boolean inputLowError){
        super(msg);
        this.source = source;
        this.inputLowError = inputLowError;
    }

    public String getSource() {
        return source;
    }

    /**
     * 输入内容过少
     * @return
     */
    public boolean isInputLowError() {
        return inputLowError;
    }

    private boolean inputLowError = false;
    private String source;
}
