package com.walker.semantics;

import com.walker.semantics.util.SemanticsUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class OwnerTextStore implements Serializable {

    public String getWord(String id){
        return this.idAndTextCache.get(id);
    }

    public Integer[] getWordHashCode(String id){
        return this.idAndWordHashCache.get(id);
    }

    public void putWord(String id, String words){
        this.idAndWordHashCache.put(id, SemanticsUtils.acquireWordHashCode(words));
        this.idAndTextCache.put(id, words);
    }

    public String getOwner(){
        return this.owner;
    }

    public OwnerTextStore(String owner){
        this.owner = owner;
    }

    public Map<String, String> getIdAndTextCache() {
        return idAndTextCache;
    }

    public Map<String, Integer[]> getIdAndWordHashCache() {
        return idAndWordHashCache;
    }

    private String owner;

    // key = 业务ID，value = 原始关键词内容，逗号分隔的，回显数据使用
    private final Map<String, String> idAndTextCache = new HashMap<>(256);

    // 存储 key = 业务ID，value = 词库关键词Hash值（多个）
    private final Map<String, Integer[]> idAndWordHashCache = new HashMap<>(256);
}
